'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { controller } = app;
  const sbRouter = app.router.namespace(app.config.projectRootPath);

  sbRouter.post('/tasks', controller.task.create); // 创建任务
  sbRouter.get('/tasks/:taskId', controller.task.show); // 获取任务状态
  sbRouter.post('/tasks/:taskId/submit', controller.task.submit); // 提交任务参数
  sbRouter.post('/tasks/:taskId/capture', controller.task.fetchCapture); // 获取验证码

  sbRouter.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外

  sbRouter.get('/scripts', controller.script.fetchScripts); // 获取所有脚本信息
  sbRouter.get('/scripts/:scriptId', controller.script.fetchOneScripts); // 获取单一脚本信息

  sbRouter.get('/help/:scriptId', controller.script.fetchHelpInfo); // 获取帮助信息
  sbRouter.get('/notice/:scriptId', controller.script.fetchNoticeInfo);// 获取提示信息
  sbRouter.get('/query_button/:scriptId', controller.script.fetchQueryButtonInfo); // 获取查询按钮信息

  sbRouter.get('/params', controller.script.fetchParamsInfo); // 获取登录参数字典
  sbRouter.post('/tokens', controller.token.create); // 创建token
  sbRouter.post('/orders', controller.order.create); // 创建订单号
  sbRouter.post('/orders/:orderId', controller.order.show); // 获取订单号详情


  sbRouter.get('/hubs/:hubId/scripts', controller.script.fetchHubSeripts);// 根据hubId 获取脚本数据（数组）

  sbRouter.get('/theme/:appKey', controller.partner.show);// 根据hubId 获取脚本数据（数组）

  // 这个接口之后会移除掉
  sbRouter.get('/orders', controller.order.fetchOrderId);

  sbRouter.post('/getToken', controller.token.createForPartner);
};
