/**
 * Created by xaj on 2017/6/5.
 * Used for the configuration of webserver
 */
var config = require('doohanpub').config;

var httpPort     = config.get('httpPort');
var httpsPort    = config.get('httpsPort');
var timeInterval = config.get('timeInterval');

module.exports = {
    //To set the port of http or https server
    ports: {
        httpPort  : process.env.WEBSERVER_CONFIG_HTTPPORT || httpPort,
        httpsPort : process.env.WEBSERVER_CONFIG_HTTPSPORT || httpsPort
    },

    //To set the ssl options for https
    ssl: {
        //sslEnabled : process.env.WEBSERVER_CONFIG_SSL_ENABLED || true,
        sslCert    : process.env.WEBSERVER_CONFIG_SSL_CERT || './ca/3_.51gjj.com_bundle.crt',
        sslKey     : process.env.WEBSERVER_CONFIG_SSL_KEY || './ca/3_.51gjj.com.key'
    },

    //To set the timer for clean log
    timer: {
        timeInterval: timeInterval || '00 00 00 * * *'
    }
};
