'use strict';
$.ajax = function(args) {
    var request=new XMLHttpRequest();

    var url = args.url;
    var data = args.data || {};

    request.onreadystatechange=function(){
        if (request.readyState == 4) {
            if(request.status == 200){
                var dataType = null;
                if ('dataType' in args) {
                    dataType = args.dataType;
                }else{
                    if(/\bContent\-Type\s*:\s* ([^\n;]+)(?=\n|;)/i.test(request.getAllResponseHeaders())){
                        var contentType = RegExp.$1;
                        if(/^\s*application\/json\s*$/i.test(contentType) || /^\s*text\/json\s*$/i.test(contentType)){
                            dataType = 'json';
                        }else if(/^\s*text\/html\s*$/i.test(contentType) || /^\s*text\/plain\s*$/i.test(contentType)){
                            dataType = 'text';
                        }else{
                            dataType = 'text';
                        }
                    }
                }
                var data = null;
                if(/^json$/i.test(dataType)){
                    data = JSON.parse(request.responseText);
                }else {
                    data = request.responseText;
                }
                try{
                    if (typeof args.success == 'function') {
                        args.success(data);
                    }
                } catch (e) {
                }
            }else{
                if (typeof args.error == 'function') {
                    args.error(request.status);
                }
            }
        }
    }
    if ('timeout' in args) {
        request.timeout = args.timeout;
    }
    if ((args.type&&/^post$/gi.test(args.type))) {
        request.open("POST",url,true);
        request.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
        var sp = '',content = '';
        for(var prop in data){
            content+= sp + prop + '=' + encodeURIComponent(data[prop]);
            sp = '&';
        }
        request.send(content);
    }else{
        var sp = /\?/.test(url)?'&':'?';
        for(var prop in data){
            url+= sp + prop + '=' + encodeURIComponent(data[prop]);
            sp = '&';
        }
        request.open("GET",url,true);
        request.send();
    }
}

function getURLParams( url ) {
    var urlParts = url.split("?");
    var result = {};
    if( urlParts[1] ) {
        var params = urlParts[1].split("&");

        for ( var i = 0; i < params.length; ++i ) {
            var item = params[i].split("=");
            var key = decodeURIComponent(item[0]);
            var val = decodeURIComponent(item[1]);
            result[key] = val;
        }
    }
    return result;
}

function serializeParams(data){
    var serializedParams = '';
    for (var pro in data) {
        serializedParams += (serializedParams.length?'&':'') + pro + '='+encodeURIComponent(data[pro]);
    }
    return serializedParams;
}

function extendMethod (class_name,method_set) {
    for (var method_name in method_set) {
        class_name.prototype[method_name] = method_set[method_name];
    }
}

function EventListener(){
}

extendMethod(EventListener,{
    on : function(event,func) {
        if (typeof event === 'string' && typeof func === 'function') {
            var list = this['on'+event+'list'];
            if (list instanceof Array) {
                for (var i = 0; i < list.length; i++) {
                    if (list[i]===func) {
                        return this;
                    }
                }
                list.push(func);
            }else{
                this['on'+event+'list']=[func];
            }
        }
        return this;
    },

    off : function(event,func){
        var list = this['on'+event+'list'];
        if (list instanceof Array) {
            if (!func) {
                list.length && list.splice(0,list.length);
            }else{
                for (var i = 0; i < list.length; i++) {
                    if (list[i]===func) {
                        list.splice(i,1);
                        break;
                    }
                }
            }
        }
        return this;
    },

    trigger : function(event){
        var result = false, list = this['on'+event+'list'];
        if (list instanceof Array) {
            for(var i=0;i<list.length;i++){
                var func = list[i];
                if(typeof func != 'function'){
                    continue;
                }
                var args = Array.prototype.slice.call(arguments, 0);
                args.shift();
                result = result || func.apply(this,args);
            }

        }
        return result;
    }
});

function __(){
    this.timer = 0;
    this.queue = [];
    this.complete = null;
}

__.prototype.then = function(cb,delay){
    this.queue.push({callback:cb,delay:delay});
    return this;
}

__.prototype.end = function(cb){
    this.complete = cb;
    return this;
}

__.prototype.abort = function(){
    if(this.timer) {
        clearTimeout(this.timer);
        this.timer = 0;
    }
    return this;
}

__.prototype.commit = function(){
    var self = this;
    if (this.queue.length && !this.timer) {
        var top = this.queue.shift();
        if (typeof top.callback == 'function') {
            if (typeof top.delay != 'number' || top.delay <=0) {
                top.callback.apply(self);
                this.commit();
            }else{
                this.timer = setTimeout(function(){
                    top.callback.apply(self);
                    self.timer = 0;
                    self.commit();
                }, top.delay);
            }
        }else{
            self.commit();
        }
    }else if(!this.queue.length && !this.timer){
        if (typeof this.complete == 'function') {
            this.complete.apply(this);
            this.complete = null;
        }
    }
    return this;
}

function then(cb,delay){
    return (new __()).then(cb,delay);
}

$(function(){
    document.body.addEventListener('touchstart', function(){});
});