$.extend($.fn,{
    valMap:function(){
        var data = {};
        for (var i = 0; i < this.length; i++) {
            var ele = $(this[i]);
            var name = ele.attr('name');
            if (name) {
                data[name]=ele.val();
            }
        }
        return data;
    },
    checkAll:function(strict){
        for (var i = 0; i < this.length; i++) {
            var errmsg = $(this[i]).checkVal(strict);
            if (errmsg) {
                return errmsg;
            }
        }
        return null;
    },
    checkVal:function(strict){
        var self = $(this),val = self.val(),errmsg = null,label = self.data('label');
        if (self.hasClass('required')) {
            if(/^\s*$/.test(val)){
                return (label && (errmsg = '请先填写'+label))||(errmsg = '请填写完所有必填的内容'),errmsg;
            }
        }
        if (self.hasClass('required-checked')&&self.is('[type=checkbox]')){
            if(!self.is(':checked')){
                return self.data('msg')||'请先勾选';
            }
        }
        if (!!strict) {
            if (self.hasClass('useIDCard')) {
                if(!/^\d{14}(\d{3})?[\dXx]$/.test(val)){
                    return '身份证格式不对';
                }
            }

            if (self.hasClass('usePhone')) {
                if(!/^1\d{10}$/.test(val)){
                    return '手机格式不正确';
                }
            }

            if (self.hasClass("useEmail")) {
                if (!/^(\w)+(\.\w+)*@(\w)+((\.\w+)+)$/.test(val)) {
                    return '邮箱格式不正确';
                }
            }

            if (self.attr('data-equal')){
                var target = $('[name='+self.attr('data-equal')+']');
                if (target.val()!=self.val()) {
                    return label+'与'+target.data('label')+"不一致";
                }
            }
        }
        return errmsg;
    },
    inteSub:function(selector,doSubmit,doAbort,body){
        var items = typeof selector == 'object'?selector:(body?$(body).find(selector):$(selector));
        var func = (function(items,button){
            return function(){
                if (items.not("[type=checkbox]").length == 0) {
                    button.addClass('disabled').attr("disabled","disabled");
                    return;
                }
                for (var i = 0; i < items.length; i++) {
                    var r = $(items[i]);
                    if (r.is("[type=hidden]")) {
                        if (!r.parent().is(":visible")) {
                            continue;
                        }
                    }else if (r.is("[type=checkbox]")) {
                        if(!r.is(":visible") && !r.parent().is(":visible")){
                            continue;
                        }
                    }else if(!r.is(":visible")){
                        continue;
                    }
                    var errmsg = r.checkVal();
                    if (errmsg) {
                        button.addClass('disabled').attr("disabled","disabled");
                        return;
                    }
                }
                button.removeClass('disabled').removeAttr("disabled");
            }
        })(items,this);
        items.off('input change').on('input change',func).eq(0).trigger('input').not("[type=checkbox]").length || this.addClass('disabled').attr("disabled","disabled");
        this.off('click').on('click',function(){
            var data = {};
            for (var i = 0; i < items.length; i++) {
                var r = $(items[i]);
                if (r.is("[type=hidden]")) {
                    if (!r.parent().is(":visible")) {
                        continue;
                    }
                }else if (r.is("[type=checkbox]")) {
                    if(!r.is(":visible") && !r.parent().is(":visible")){
                        continue;
                    }
                }else if(!r.is(":visible")){
                    continue;
                }
                var errmsg = r.checkVal(true);
                if (errmsg) {
                    typeof doAbort == 'function' && doAbort.call($(this),errmsg);
                    return;
                }
                var name = r.attr('name');
                name && !/^\s*$/.test(r.val()) &&(data[name]=r.val());
            }
            typeof doSubmit == 'function' && doSubmit.call($(this),data);
        });
    },
    lock:function(cd){
        var self = $(this),text = self.html(),i = cd;
        self.data('origin-text',text);
        var call = function(){
            if(i>0){
                self.html(i+'秒');
                self.attr("disabled","disabled");
            } else {
                self.html(self.data('origin-text'));
                self.removeAttr("disabled");
                self.data('timer',0);
                clearInterval(timer);
                self.trigger("clickready");
            }
            i--;
        }
        var timer = setInterval(call,1000);
        self.data('timer',timer);
        call();
        var id = self.data('id');
        if (window.localStorage && id) {
            var cache = window.localStorage['lock_cd'];
            if (cache) {
                cache = JSON.parse(cache);
            }else{
                cache = {}
            }
            cache[id] = Math.round(new Date().getTime()/1000)+cd;
            window.localStorage['lock_cd'] = JSON.stringify(cache);
        }
    },
    unlock:function(){
        var self = $(this);
        self.html(self.data('origin-text'));
        self.removeAttr("disabled");
        var timer = self.data('timer');
        timer && clearInterval(timer);
        var id = self.data('id');
        if (window.localStorage) {
            var cache = window.localStorage['lock_cd'];
            if (cache) {
                cache = JSON.parse(cache);
            }else{
                cache = {}
            }
            delete cache[id];
            window.localStorage['lock_cd'] = JSON.stringify(cache);
        }
    },
    restoreLock:function(){
        var self = $(this);
        if (window.localStorage) {
            var cache = window.localStorage['lock_cd'];
            if (cache) {
                cache = JSON.parse(cache);
            }
            var now = Math.round(new Date().getTime()/1000);
            for (var id in cache) {
                var cdt = cache[id];
                if (cdt-now>0 ) {
                    (self.data('id')==id?self:self.find('[data-id='+id+"]")).lock(cdt-now);
                }
            }
        }
    }
    ,lockCD:function(){
        var self = $(this);
        var lock_id = self.data('id');
        if (window.localStorage && lock_id) {
            var cache = window.localStorage['lock_cd'];
            if (cache) {
                cache = JSON.parse(cache);
            }
            var now = Math.round(new Date().getTime()/1000);
            if (lock_id in cache) {
                var cdt = cache[lock_id];
                if (cdt-now>0) {
                    return cdt-now;
                }
            }
        }
        return 0;
    }
});

$(function(){
    $(document).restoreLock();
});
