/**
 * Created by xaj on 2017/6/5.
 */
var express = require('express');
var router  = express.Router();

// catch 404 and forward to error handler
router.use(function(req, res, next) {
    var err = new Error('Page Not Found');
    err.status = 404;
    next(err);
});

// error handler
router.use(function(err, req, res, next) {
    // set locals, only providing error in development
    res.locals.message = err.message;
    res.locals.error = req.app.get('env') === 'development' ? err : {};

    console.error('[/default] router error, path: ' + req.path)
    console.error(err)
    // render the error page
    // res.status(err.status || 500);
    return res.render("Err", {title: "初始url错误", tip: "建议检查初始url是否正确"})
});

module.exports = router;