/**
 * Created by xaj on 2017/5/26.
 */

var http         = require('http');
var https        = require('https');
var fs           = require('fs');
var config       = require('doohanpub').config;
var expressWs    = require('express-ws');
var express      = require('express');        // call express
var bodyParser   = require('body-parser');
var cookieParser = require('cookie-parser');
var path         = require('path');
var hbs          = require('hbs');

var scheduleproc = require('./lib/scheduleproc');

var conf      = require('./config');
var httpsPort = conf.ports.httpsPort;
var httpPort  = conf.ports.httpPort;

// var sslEnabled = true;
// if (conf.ssl && 'false' == conf.ssl.sslEnabled){
//     sslEnabled = false;
// }

// var https_options  = {
//     // SSLEnabled: sslEnabled,
//     key: fs.readFileSync(conf.ssl.sslKey),
//     cert: fs.readFileSync(conf.ssl.sslCert)
// };

var app = express();

app.set('env', 'production');

// ---启动http server
var Server = http.createServer(app);
Server.listen(httpPort,  function() {
    console.log((new Date()) + ' Gongjijin start http server and listen on: ' + JSON.stringify(Server.address()));
});
expressWs(app, Server);
// ---启动https server
// var sServer = https.createServer(https_options, app);
// sServer.listen(httpsPort, function() {
//     console.log((new Date()) + ' Gongjijin start https server and listen on: ' + JSON.stringify(sServer.address()));
// });
// expressWs(app, sServer);

var gongjijin = require('./routes/shebao/index');
var defaul    = require('./routes/defaul/index');

app.set('view engine', 'hbs');
app.set('views', __dirname + '/public/views');
hbs.registerPartials(__dirname + '/public/views/partials');


//X-Frame-Options: Allow-From http://www.growingio.com
app.use('*', function(req, res, next){
    res.setHeader('X-Frame-Options', 'ALLOW-FROM https://www.growingio.com');
    next();
})

// 给app配置bodyParser中间件
// 通过如下配置再路由种处理request时，可以直接获得post请求的body部分
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));

// 注册路由
app.use('/shebao', gongjijin); // 公积金
app.use(defaul);


// 定时清理日志任务
var timeInterval = conf.timer.timeInterval;
scheduleproc.BeginCleanLogWork(timeInterval);
// scheduleproc.BeginCleanPm2LogWork();
// scheduleproc.cleanLogJob();
