'use strict';

const Controller = require('egg').Controller;

class PartnerController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.showRule = {
      sign: { type: 'string', required: true },
      type: { type: 'string', required: false },
      params: {
        type: 'object', required: true, rule: {
          appKey: { type: 'string', required: true },
          timestamp: { type: 'string', required: true },
          token: { type: 'string', required: true },
          orderId: { type: 'string', required: true },
        },
      },
    };
    this.createRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };
  }

  async show() {
    const { ctx, service } = this;
    const { appKey } = ctx.params;
    const ret = await service.partner.fetchTheme(appKey);
    if (ret && ret.appKey === appKey) {
      ctx.success(ret);
      return;
    }
    ctx.fail('尚未配置主题');
  }

  async getToken() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.createRule);
      const token = await service.signature.createToken(ctx.request.body);
      ctx.body = {
        code: 0,
        data: { token },
        msg: '',
      };
    } catch (err) {
      ctx.logger.error('partnerCreate', JSON.stringify(err));
      ctx.status = 200;
      if (err.code === 'invalid_param') {
        ctx.body = { code: -1, msg: '请求参数有误' };
        return;
      }
      if (/[a-zA-Z]+/.test(err.message)) {
        ctx.body = { code: err.code || -1, msg: '系统错误, 请稍后再试' };
        return;
      }
      ctx.body = { code: err.code || -1, msg: err.message || '' };
    }
  }

  async fetchAgreements() {
    const { ctx, service } = this;
    const { id } = ctx.params;
    const ret = await service.partner.fetchAgreements(id);
    if (ret && String(ret.id) === id) {
      ctx.success(ret);
      return;
    }
    ctx.fail('未获取到协议');
  }
}

module.exports = PartnerController;
