'use strict';

const moment = require('moment');

module.exports = app => {
  const { DataTypes } = app.Sequelize;

  const taskStatus = app.model.define('taskStatus', {
    id: {
      type: DataTypes.INTEGER(20),
      allowNull: false,
      primaryKey: true,
      autoIncrement: true,
      field: 'id',
    },
    orderId: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      primaryKey: false,
      field: 'orderId',
    },
    taskId: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: '',
      field: 'taskId',
    },
    userId: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: '',
      field: 'userId',
    },
    cityId: {
      type: DataTypes.STRING(10),
      allowNull: true,
      defaultValue: '',
      field: 'cityId',
    },
    appkey: {
      type: DataTypes.STRING(100),
      allowNull: false,
      field: 'appkey',
    },
    callbackUrl: {
      type: DataTypes.STRING(255),
      allowNull: false,
      defaultValue: '',
      field: 'callbackUrl',
    },
    status: {
      type: DataTypes.STRING(50),
      allowNull: false,
      defaultValue: '',
      field: 'status',
    },
    note: {
      type: DataTypes.STRING(8000),
      allowNull: true,
      defaultValue: '',
      field: 'note',
      get() {
        const note = this.getDataValue('note');
        if (note) {
          try {
            return JSON.parse(note);
          } catch (error) {
            return {};
          }
        }
        return {};
      },
      set(val) {
        this.setDataValue('note', JSON.stringify(val));
      },
    },
    createDate: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('createDate');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    updateDate: {
      type: DataTypes.DATE,
      get() {
        const date = this.getDataValue('updateDate');
        return date ? moment(date).format('YYYY-MM-DD HH:mm:ss') : undefined;
      },
    },
    type: {
      type: DataTypes.STRING(1),
      allowNull: true,
      defaultValue: '',
      field: 'type',
    },
    notice: {
      type: DataTypes.INTEGER(1),
      allowNull: true,
      field: 'notice',
    },
  }, {
    tableName: 'sbH5_status',
    timestamps: false,
  });

  return taskStatus;
};
