'use strict';

module.exports = () => {
  const config = exports = {};
  config.debug = false;

  config.taskAPI = {
    host: process.env.TASKAPI_HOST,
    fetchHubsUrl: '',
    createTaskUrl: '/shebao/createSbTask',
    fetchCodeUrl: '/shebao/getSbCode',
    submitTaskUrl: '/shebao/loginSbWeb',
    fetchTaskUrl: '/shebao/getSbData', // 获取该task状态
    redisTaskPrefix: 'DATA_SERVER_SHEBAO.TASK',
  };

  config.partnerAPI = {
    host: process.env.PARTNERAPI_HOST,
    fetchTheme: '/chaos/theme',
    fetchScripts: '/chaos/partners/scripts',
    redisThemePrefix: 'DATA_SERVER_SHEBAO.PARNTERS.THEME',
    redisScriptsPrefix: 'DATA_SERVER_SHEBAO.PARNTERS.SCRIPTS',
    fetchAgreements: '/chaos/agreements',
    redisAgreementsPrefix: 'DATA_SERVER_SHEBAO.AGREEMENTS',
    fetchInfo: '/chaos/partner',
    redisInfoPrefix: 'DATA_SERVER_SHEBAO.PARTNERINFO',
  };

  config.scriptsAPI = {
    host: process.env.SCRIPTSAPI_HOST,
    fetchScriptsUrl: '/chaos/ss/two_dimension_array/queries',
    fetchOneScriptUrl: '/chaos/ss/two_dimension_array/info',
    fetchParamsInfoUrl: '/chaos/ss/login_param_map',
    fetchQueryButtonUrl: '/chaos/ss/query_button',
    fetchHelpUrl: '/chaos/ss/help',
    fetchNoticeUrl: '/chaos/ss/notice',
    fetchHubSeriptsUrl: '/chaos/ss/hubs',
    centersInfoUrl: 'https://t.51gjj.com/shebao/centersInfo',
    cityInfoUrl: 'https://t.51gjj.com/shebao/cityConfig',
    fetchScriptByCityNameUrl: '/chaos/ss/city_scripts',
    redisScriptsKey: 'DATA_SERVER_SHEBAO.SCRIPTS',
    redisParamsKey: 'DATA_SERVER_SHEBAO.PARAMS',
    redisScriptListKey: 'DATA_SERVER_SHEBAO.SCRIPTLIST',
  };

  config.storageAPI = {
    host: 'https://lan-nginx.jianbing.com/mongo-service/data',
    writeUrl: '',
    readUrl: '?type=shebao&id=',
    writeType: 'shebao',
    readDataKey: 'shebaoData',
  };

  config.washAPI = {
    host: process.env.WASHAPI_HOST,
    washUrl: '/si/analyzeSI',
  };

  config.signatureAPI = {
    host: 'https://only-lan-nginx.jianbing.com/customer-validation',
    fetchTokenUrl: '/access/gettoken',
    fetchOrderIdUrl: '/order/getordersn',
    signatureUrl: '/access/signvaliditycheck',
    fetchParnterUrl: '',
    signatureType: 'shebao',
    customerUrl: '/customer/query',
  };

  config.redisKeys = {
    fecthHub: 'NEWSB.SS.HUBS.LOCK',
    fecteToken: 'NEWSB.SS.TOKEN.LOCK',
    token: 'NEWSB.SS.TOKEN',
    fecthParnters: 'NEWSB.PARNTERS.LOCK',
    taskPrefix: 'NEWSB.TASK',
  };

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'nodemodel',
      baseDir: 'model/nodegjj',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST,
      database: process.env.MYSQL_NODE_DB_NAME || 'node_gjj',
      username: process.env.MYSQL_USER,
      password: process.env.MYSQL_PWD,
      port: process.env.MYSQL_PORT,
    }, {
      // 东八时区
      timezone: '+08:00',
      delegate: 'model',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST,
      database: process.env.MYSQL_DATA_SERVER_DB_NAME,
      username: process.env.MYSQL_USER,
      password: process.env.MYSQL_PWD,
      port: process.env.MYSQL_PORT,
    }, {
      // 东八时区
      timezone: '+08:00',
      delegate: 'javaSb',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST,
      database: process.env.MYSQL_JAVA_DB_NAME,
      username: process.env.MYSQL_USER,
      password: process.env.MYSQL_PWD,
      port: process.env.MYSQL_PORT,
    }],
  };

  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST,
      password: process.env.REDIS_PWD,
      db: 0,
    },
  };

  config.SB_OpenAPI = {
    appKey: '60670203E411FD62BA9E953CFB73F881',
    appSecret: '0BDD1ECC147503C477563E5C1438C366D70E4F80',
  };

  config.callbackUrl = process.env.CALLBACK_URL;

  return config;
};
