'use strict';

const Controller = require('egg').Controller;

class TokenController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };
  }

  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule);
    const token = await service.signature.createToken(ctx.request.body);
    ctx.success({ data: token });
  }

  // 处理响应状态码的问题
  async createForPartner() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.createRule);
    } catch (e) {
      ctx.body = { code: 101, msg: e.errors };
      return;
    }
    const token = await service.signature.createTokenForPartner(ctx.request.body);
    ctx.body = { code: 0, data: token };
  }
}

module.exports = TokenController;
