'use strict';

const Controller = require('egg').Controller;

class OrderController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      appKey: { type: 'string', required: true },
      userId: { type: 'string', required: true },
      notifyUrl: { type: 'string', required: false },
      redirectUrl: { type: 'string', required: false },
      orderId: {
        type: 'string',
        required: false,
        format: /^(\w{8})-(\w{4})-(\w{4})-(\w{4})-(\w{12})$/,
        message: '订单号格式错误',
      },
    };

    this.showRule = {
      sign: 'string',
      params: {
        type: 'object', required: true,
        rule: {
          token: { type: 'string', required: true },
          orderId: { type: 'string', required: true },
          appKey: { type: 'string', required: true },
          timestamp: { type: 'string', required: true },
        },
      },
    };
  }

  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule);
    // const { appKey } = ctx.request.body.params;
    const { appKey, userId, notifyUrl, redirectUrl } = ctx.request.body;
    // const orderId = await service.signature.createOrderId(ctx.request.body);
    const orderId = await ctx.helper.getUuid();
    await service.order.create({
      orderId,
      taskId: '',
      userId,
      cityId: '',
      appkey: appKey,
      status: 'init',
      notifyUrl,
      redirectUrl,
    });
    ctx.success({ orderId });
  }

  // 只根据订单号获取数据
  // async show() {
  //   const { ctx, service } = this;
  //   ctx.validate(this.showRule);
  //   const { orderId, appKey } = ctx.params;
  //   await service.signature.signatureCheck(ctx.request.body);
  //   const data = await service.order.getOneByOrderId(orderId);
  //   if (data) {
  //     if (data.status === 'success') {
  //       const result = await service.storage.read(orderId, appKey);
  //       ctx.success(result);
  //       return;
  //     }
  //     ctx.success({
  //       status: data.status,
  //     });
  //     return;
  //   }
  //   ctx.fail('无此订单号');
  // }

  async fetchOrderId() {
    const { ctx, service } = this;
    const token = await service.signature.getToken();
    const signParams = ctx.helper.buildRequestBody({ token });
    const { appKey } = signParams.params;
    const orderId = await service.signature.createOrderId(signParams);
    await service.order.create({
      orderId,
      taskId: '',
      userId: '',
      cityId: '',
      appkey: appKey,
      status: 'init',
    });
    ctx.success({ orderId });
  }

  async orderShow() {
    const { ctx, service } = this;
    const { appKey, orderId } = ctx.params;
    const data = await service.order.getOneByOrderId(orderId);
    if (data) {
      if (data.status === 'success' && (data.appKey === appKey)) {
        const result = await service.storage.read(orderId, appKey);
        const ret = service.washData.dealData(result);
        ctx.success(ret);
        return;
      }
    }
    ctx.fail('无此订单号');
  }
}

module.exports = OrderController;
