'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { controller } = app;
  const sbRouter = app.router.namespace(app.config.projectRootPath);

  sbRouter.post('/tasks', controller.task.create); // 创建任务
  sbRouter.get('/tasks/:taskId', controller.task.show); // 获取任务状态 前端轮询的接口
  sbRouter.post('/tasks/:taskId/submit', controller.task.submit); // 提交任务参数
  sbRouter.post('/tasks/:taskId/capture', controller.task.fetchCapture); // 获取验证码

  sbRouter.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外

  sbRouter.get('/scripts', controller.script.fetchScripts); // 获取所有脚本信息
  sbRouter.get('/scripts/:scriptId', controller.script.fetchOneScripts); // 获取单一脚本信息

  sbRouter.get('/help/:scriptId', controller.script.fetchHelpInfo); // 获取帮助信息
  sbRouter.get('/notice/:scriptId', controller.script.fetchNoticeInfo);// 获取提示信息
  sbRouter.get('/query_button/:scriptId', controller.script.fetchQueryButtonInfo); // 获取查询按钮信息

  sbRouter.get('/params', controller.script.fetchParamsInfo); // 获取登录参数字典
  sbRouter.post('/tokens', controller.token.create); // 创建token
  sbRouter.post('/orders', controller.order.create); // 创建订单号


  sbRouter.get('/hubs/:hubId/scripts', controller.script.fetchHubSeripts);// 根据hubId 获取脚本数据（数组）

  sbRouter.get('/theme/:appKey', controller.partner.show); // 根据appKey查询合作方的主题

  sbRouter.get('/agreements/:id', controller.partner.fetchAgreements); // 查询协议
  sbRouter.post('/getToken', controller.partner.getToken); // 合作方获取token
  sbRouter.post('/getData', controller.partner.partnerShow); // 合作方获取订单数据
  sbRouter.post('/getCityConfig', controller.task.fetchCityConfig); // 合作方获取城市配置
  sbRouter.get('/orderData/:appKey/:orderId', controller.order.orderShow); // 获取展示页面数据
};
