'use strict';

module.exports = () => {
  const config = exports = {};
  config.debug = false;

  config.taskAPI = {
    host: process.env.TASKAPI_HOST,
    fetchHubsUrl: '',
    createTaskUrl: '/shebao/createSbTask',
    fetchCodeUrl: '/shebao/getSbCode',
    submitTaskUrl: '/shebao/loginSbWeb',
    fetchTaskUrl: '/shebao/getSbData', // 获取该task状态
    redisTaskPrefix: 'DATA_SERVER_SHEBAO.TASK',
  };

  config.partnerAPI = {
    host: process.env.PARTNERAPI_HOST,
    fetchTheme: '/chaos/partners/theme',
    fetchScripts: '/chaos/partners/scripts',
    redisThemePrefix: 'DATA_SERVER_SHEBAO.PARNTERS.THEME',
    redisScriptsPrefix: 'DATA_SERVER_SHEBAO.PARNTERS.SCRIPTS',
  };

  config.scriptsAPI = {
    host: process.env.SCRIPTSAPI_HOST,
    fetchScriptsUrl: '/chaos/hf/two_dimension_array/queries',
    fetchOneScriptUrl: '/chaos/hf/two_dimension_array/info',
    fetchParamsInfoUrl: '/chaos/hf/login_param_map',
    fetchQueryButtonUrl: '/chaos/hf/query_button',
    fetchHelpUrl: '/chaos/hf/help',
    fetchNoticeUrl: '/chaos/hf/notice',
    fetchHubSeriptsUrl: '/chaos/hf/hubs',
    centersInfoUrl: 'https://t.51gjj.com/shebao/centersInfo',
    cityInfoUrl: 'https://t.51gjj.com/shebao/cityConfig',
    fetchScriptByCityNameUrl: '/chaos/hf/city_scripts',
    redisScriptsKey: 'DATA_SERVER_SHEBAO.SCRIPTS',
    redisParamsKey: 'DATA_SERVER_SHEBAO.PARAMS',
  };

  config.storageAPI = {
    host: process.env.STORAGEAPI_HOST,
    writeUrl: '/data',
    readUrl: '/shebao',
    writeType: 'shebao',
    readDataKey: 'shebaoData',
  };

  config.washAPI = {
    host: process.env.WASHAPI_HOST,
    washUrl: '/si/analyzeSI',
  };

  config.signatureAPI = {
    host: process.env.SIGNATUREAPI_HOST,
    fetchTokenUrl: '/Access/GetToken',
    fetchOrderIdUrl: '/Order/GetOrderSn',
    signatureUrl: '/Access/SignValidityCheck',
    fetchParnterUrl: '',
    signatureType: 'shebao',
    customerUrl: '/customer/query',
  };

  config.redisKeys = {
    fecthHub: 'NEWSB.HF.HUBS.LOCK',
    fecteToken: 'NEWSB.HF.TOKEN.LOCK',
    token: 'NEWSB.HF.TOKEN',
    fecthParnters: 'NEWSB.PARNTERS.LOCK',
  };

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'model',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST,
      database: process.env.MYSQL_DATA_SERVER_DB_NAME,
      username: process.env.MYSQL_USER,
      password: process.env.MYSQL_PWD,
      port: process.env.MYSQL_PORT,
    }, {
      // 东八时区
      timezone: '+08:00',
      delegate: 'cusPro',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST,
      database: process.env.MYSQL_JAVA_DB_NAME,
      username: process.env.MYSQL_USER,
      password: process.env.MYSQL_PWD,
      port: process.env.MYSQL_PORT,
    }],
  };

  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST,
      password: process.env.REDIS_PWD,
      db: 0,
    },
  };

  config.SB_OpenAPI = {
    appKey: '60670203E411FD62BA9E953CFB73F881',
    appSecret: '0BDD1ECC147503C477563E5C1438C366D70E4F80',
  };

  config.callbackUrl = process.env.CALLBACK_URL;

  return config;
};
