'use strict';

const Service = require('egg').Service;


class CacheService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    const { taskPrefix } = config.lockKeys;
    this.taskPrefix = taskPrefix;
  }

  /**
   * 将taskId状态缓存到cache和数据库
   * @param {Object} key taskId
   *   - value: 状态 提示信息 status 、note={}
   *   - exprie: 过期时间(单位/s)
   */
  async set({ key, value = {}, expire = 300 }) {
    const { ctx, app, taskPrefix } = this;

    const data = await app.cache.get(taskPrefix + key);
    if (!data || (data && data.status !== 'success')) {
      await app.cache.set(taskPrefix + key, value, expire);
    }

    const order = await ctx.model.TaskStatus.findOne({
      where: { taskId: key },
    });
    if (order && order.status !== 'success') {
      await order.update({ ...value });
    } else {
      ctx.logger.error('【Cache】set no order or already success', key);
    }
  }

  /**
 * 获取task状态 优先cache
 * @param {Object} key taskId
 * @return {Object} status note
 */
  async get({ key }) {
    const { ctx, app, taskPrefix } = this;
    const data = await app.cache.get(taskPrefix + key);
    if (data) {
      ctx.logger.info(`【Cache】get From node-cache ${key} data:`, data);
      return data;
    }
    const order = await ctx.model.TaskStatus.findOne({
      where: { taskId: key },
    });
    if (order) {
      ctx.logger.info(`【Cache】get From Model ${key} order:`, { status: order.status, note: order.note });
      return { status: order.status, note: order.note };
    }
    ctx.logger.error(`【Cache】get No Result ${key}`);
    ctx.throw(400, { message: 'no taskId' });
  }

}

module.exports = CacheService;
