'use strict';

const Controller = require('egg').Controller;

class PartnerController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.showRule = {
      sign: { type: 'string', required: true },
      type: { type: 'string', required: false },
      params: {
        type: 'object', required: true, rule: {
          appKey: { type: 'string', required: true },
          timestamp: { type: 'string', required: true },
          token: { type: 'string', required: true },
          orderId: { type: 'string', required: true },
        },
      },
    };
  }

  async show() {
    const { ctx, service } = this;
    const { appKey } = ctx.params;
    const ret = await service.partner.fetchTheme(appKey);
    if (ret && ret.id === appKey) {
      ctx.success(ret);
      return;
    }
    ctx.fail('尚未配置主题');
  }

  async getToken() {
    const { ctx, service } = this;
    ctx.status = 200;
    try {
      ctx.validate(this.createRule);
      const token = await service.signature.createTokenForPartner(ctx.request.body);
      ctx.body = { code: 0, data: token };
    } catch (err) {
      if (err.code === 'invalid_param') {
        ctx.body = { code: -1, message: err.message || '' };
        return;
      }
      ctx.body = { code: err.code || -1, message: err.message || '' };
      return;
    }
  }

  async fetchAgreements() {
    const { ctx, service } = this;
    const { id } = ctx.params;
    const ret = await service.partner.fetchAgreements(id);
    if (ret && String(ret.id) === id) {
      ctx.success(ret);
      return;
    }
    ctx.fail('未获取到协议');
  }
}

module.exports = PartnerController;
