'use strict';

module.exports = {
  schedule: {
    interval: '5m', // 5分钟间隔
    type: 'all', // 所有woker
    immediate: true,
  },

  async task(ctx) {
    try {
      const result = await ctx.javaSb.query('SELECT id, name FROM shebao_city', { type: 'SELECT' });
      const cityNameMap = new Map();
      for (const item of result) {
        cityNameMap.set(String(item.id), item.name);
      }
      ctx.app.cityNameMap = cityNameMap;
      // console.log(ctx.app.cityNameMap);
    } catch (e) {
      ctx.logger.error(e);
    }
  },
};
