'use strict';

module.exports = (options, app) => {
  return async function(ctx, next) {
    const { query } = ctx.request;
    // 测试appKey限制
    const isLimit = await judgeLimit(query);
    if (isLimit) {
      ctx.body = { code: 107, msg: '测试appKey使用次数到达限制' };
      return;
    }
    await next();
  };
};

async function judgeLimit(params) {
  const { ctx, app } = this;
  const { appKey } = params;
  // ctx.logger.info(app.devAppkeyMap.keys());
  if (!app.nodeLimitMap.has(appKey)) {
    return false;
  }
  let { currentCount, limitCount, env } = app.devAppkeyMap.get(appKey);
  if (env === 'dev' && currentCount >= limitCount) {
    return true;
  }
  currentCount++;
  const upObj = {
    currentCount,
  };
  await ctx.model.NodeLimit.update(
    upObj,
    { where: { appKey } }
  );
  return false;
}
