'use strict';

const Controller = require('egg').Controller;

class TokenController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.createRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };
  }

  async create() {
    const { ctx, service } = this;
    ctx.validate(this.createRule);
    const token = await service.signature.createToken(ctx.request.body);
    ctx.success({ data: token });
  }
}

module.exports = TokenController;
