!> 特别提醒： <br> 1. 时间戳（timestamp）： 采用北京时间， 时间戳误差60秒内有效。
<br> 2. token： 获取token时，注意防并发，保持同步，以防新token生成后，老token还在使用导致失效。
<br> 3. appKey： 测试appKey的使用次数为2000次，请及时申请并更换为正式appKey。

# 文档更新说明

>| 更新日期     | 更新内容|
|:--------|---------|



# **1** 接入网址说明

## **1.1** 协议说明

> 只支持https

## **1.2** 域名说明

>| 名称     | 域名| 
|:--------|---------:|
| API| ```https://t.51gjj.com/```|




# **2** API接口


## 2.1 获取个税城市基础配置项

>**请求URL：** 
- ` IncomeTaxAPI/getCity `
  
------------
>**请求方式：**


>- Method: GET

------------

> **参数：** 
 无


```json
 {
     "code": 0,
     "data": [
         {
             "provinceName": "浙江省",
             "citys": [
                 {
                     "province": 1,
                     "name": "绍兴",
                     "id": 57,
                     "state": 1,
                     "queryParam": [
                         {
                             "loginParam": [
                                 {
                                     "note": "",
                                     "name": "ID",
                                     "type": "string"
                                 },
                                 {
                                     "note": "",
                                     "name": "password",
                                     "type": "string"
                                 },
                                 {
                                     "note": "{\"330601\":\"市本级\",\"330621\":\"柯桥区\",\"330624\":\"新昌县\",\"330681\":\"诸暨市\",\"330682\":\"上虞市\",\"330683\":\"嵊州市\"}",
                                     "name": "menu",
                                     "type": "radio"
                                 }
                             ]
                         }
                     ]
                 },
                 {
                     "province": 1,
                     "name": "杭州",
                     "id": 81,
                     "state": 1,
                     "queryParam": [
                         {
                             "loginParam": [
                                 {
                                     "note": "",
                                     "name": "ID",
                                     "type": "string"
                                 },
                                 {
                                     "note": "",
                                     "name": "password",
                                     "type": "string"
                                 },
                                 {
                                     "note": "{\"330100\":\"市本级\",\"330109\":\"萧山区\",\"330110\":\"余杭区\",\"330122\":\"桐庐县\",\"330127\":\"淳安县\",\"330182\":\"建德市\",\"330183\":\"富阳区\",\"330185\":\"临安市\"}",
                                     "name": "menu",
                                     "type": "radio"
                                 }
                             ]
                         }
                     ]
                 }
             ]
         }
     ],
     "msg": "请求成功"
 }
```


 **返回参数说明** 

>|参数名|类型|说明|
|:-----  |:-----|-----    |
|provinceName |String   |省份名称|
|id |int   |城市id|
|province |int   |省份id|
|queryParam |String   |登录参数|
|state |int   |城市状态|
|url |String   |网站地址|
|province |String   |省份id|
|name |String   |城市名称|


 **登录参数说明** 
>|登录参数|登录参数说明|type|
 |:-----  |:-----|:-----|
|ID	|身份证号|string|
|password	|密码|string|
|name	|姓名|string|
|phone	|手机号|string|
|userName	|用户名|string|
|code	|验证码|string|
|idNo	|证件号|string|
|phoneCode	|手机验证码|string|
|taxpayerId	|纳税人识别号|string|
|taxId	|税务登记证号|string|
|email	|邮箱|string|

!> 当登录参数为 type为'radio' 代表该参数类型为下拉菜单；
例如  当参数为 
 ```json
  {
        "note": "{\"3001\":\"江门市区\",\"3002\":\"新会区\",\"3003\":\"台山市\",\"3004\":\"开平市\",\"3005\":\"鹤山市\",\"3006\":\"恩平市\"}",
        "name": "区域",
        "type": "radio"
    }
   ```
    
    
!>  应将note中的数据解析，最终展示为单选框，或下拉菜单， 若当用户选择江门市区，则传回的登陆参数为 {"区域":"3001"}





## 2.2 获取个税城市查询提示信息


>**请求URL：**


- ` IncomeTaxAPI/getHelpInfo `

------------
>**请求方式：**


>- Method: GET

------------

> **参数：**


  无


> **返回示例：**

- **返回示例**

```json
{
    "code": 0,
    "data": [
        {
            "cid": 1,
            "city": "杭州",
            "help": "[{\"desc\":\"如果您未曾在浙江政务服务网进行注册的，需要前往官网注册并设置相关信息后才可查询\",\"link\":{\"label\":\"立即注册\",\"url\":\"https://puser.zjzwfw.gov.cn/sso/usp.do?action=register&servicecode=njdh\"}},{\"desc\":\"如果您忘记了密码，需要登录浙江政务服务网找回密码\",\"link\":{\"label\":\"忘记密码\",\"url\":\"https://puser.zjzwfw.gov.cn/sso/usp.do?action=forgotPwd&servicecode=njdh\"}}]"
        },
        {
            "cid": 2,
            "city": "温州",
            "help": "[{\"desc\":\"如果您未曾在浙江政务服务网进行注册的，需要前往官网注册并设置相关信息后才可查询\",\"link\":{\"label\":\"立即注册\",\"url\":\"https://puser.zjzwfw.gov.cn/sso/usp.do?action=register&servicecode=njdh\"}},{\"desc\":\"如果您忘记了密码，需要登录浙江政务服务网找回密码\",\"link\":{\"label\":\"忘记密码\",\"url\":\"https://puser.zjzwfw.gov.cn/sso/usp.do?action=forgotPwd&servicecode=njdh\"}}]"
        }
    ]
}
```





 > **返回参数说明**

|参数名|类型|说明|
|:-----  |:-----|-----    |
|cid |Number   |个税中心编号|
|city |String   |个税中心名称|
|help |Array   |帮助信息内容|





## 2.3 创建访问令牌

    

>**请求URL：** 
- ` IncomeTaxAPI/getToken `
  
------------

>**请求方式：**


>- Method: POST
- Content-Type: application/json
- Charset: UTF-8

------------


> **参数：** 
>
|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|sign |是  |String |签名   |
|appKey |是  |String |公钥   |
|timestamp |是  |String | 时间戳 （单位：ms）   |

------------

 >**请求示例**


``` json

{
	"sign":"SDSKKL5KJJKLL6JK1L",
	"params":{
		"appKey":"3FD179425381644F95424B66BE06E3E4",
		"timestamp":"1494828184314"
	}
}
```


 >**返回示例1**

``` json
{
  "code": 0,
  "data": {
    "token": "cd4283827366490eb037bf1b4b28dadc"
  }
}
```

 >**返回示例2**

``` json
{
  "code": 3000,
  "msg": "参数错误"
}
```

 >**返回参数说明** 

>|参数名|类型|说明|
|:-----  |:-----|-----                           |
|token |String   |访问令牌(Token的有效期为2小时，当Token未失效时调用该接口，则返回新的Token，有效期重新计算，老的Token同时失效) |
|code |Number   |状态码 |
|msg |String   |错误信息 |


------------

 >**备注** 


 >  状态码对应的错误信息

  |code|错误信息|处理方式|
  |:-----  |:-----|-----                           |
  |0 | 成功 | 需要注意并发 |
  |101 |参数错误或缺失  |需检查参数是否缺失或错误  |
  |3000 | 验签出错 |具体错误信息解释见4.2  |






## **2.4**   创建订单号
    
**简要描述：** 

- 通过该接口创建订单号
订单号是查询任务和获取数据的唯一标识，请妥善保管，每次任务对应一个订单号

**请求URL：** 
- path ` IncomeTaxAPI/getOrderSn `
  
**请求方式：**
- Method: POST
- Content-Type: application/json
- Charset: UTF-8

**参数：** 

|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|sign |是  |string |签名   |
|appKey |是  |string |公钥   |
|token |是  |string | 访问令牌    |
|timestamp |是  |string | 时间戳   （单位：ms）  |
|cityId |是  |string |城市编号   |




 **请求示例**


```json
{
    "signParams": {
        "params": {
            "appKey": "3FD179425381644F95424B66BE06E3E4",
            "token": "cd4283827366490eb037bf1b4b28dadc",
            "timestamp": "1504828184314"
        },
        "sign": "SDSKKL5KJJKLL6JK1L",
    },
    "cityId": "323"
}
```




 **返回示例1**

```json
{
    "code": 0, 
    "orderSn": "e7b7040b-8ea1-4585-95cc-977925d24757", 
    "msg": "任务创建成功"
}
```

 **返回示例2**

```json
{
  "code": 3000,
  "msg": "参数错误"
}
```

 **返回参数说明** 

|参数名|类型|说明|
|:-----  |:-----|-----|
|orderSn |String   |订单号  |
|code |Number   |状态码  |
|msg |String   |任务信息  |

 **备注** 

 状态码对应的信息说明

  |code|错误信息|处理方式|
  |:-----  |:-----|-----                           |
  |0 | 成功 | 可以继续接下来的步骤 |
  |101 |参数错误或缺失  |需检查参数是否缺失或错误  |
  |3000 | 验签出错 |具体错误信息解释见4.2  |
  |201 |城市维护或不支持  |因为cityId所在地区处于维护状态或不支持  |
  |500 |服务出错  |由于网络或其他原因导致服务出现问题  |



## **2.5** 获取验证码


**简要描述：** 

- 获取当前个税查询任务需要的验证码信息(即附录4.3所示的查询参数为phoneCode或code时候可调用该接口)

**请求URL：** 
- ` IncomeTaxAPI/getCode   `
  
**请求方式：**
- POST
- Content-Type = application/json
 

**参数：** 

|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|orderSn |是  |string |个税查询订单号   |
|type |是  |string | 验证码类型 code:图形验证码 phone_code:手机验证码    |

 **请求示例**
```json
{
    "orderSn":"1199a04a-d203-4d3d-b65b-0c07ce5fd9f7",
    "type":"code"
}
```



 **返回示例**
- type=code

```json
{
    "code": 0,
    "data": {
        "img": "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",
        "cityId": 12,
        "orderSn": "1199a04a-d203-4d3d-b65b-0c07ce5fd9f7"
    }
}
```


- type=phone_code

```json
{
	
	"msg":"对不起，查询短信随机码暂时不能发送，请一分钟以后再试",
	"code":115,
	"data":{
		"cityId":2,
		"orderSn": "1199a04a-d203-4d3d-b65b-0c07ce5fd9f7"
		}
}


```

 **返回参数说明** 

|参数名|类型|说明|
|:-----  |:-----|----- |
|code |int   |错误码 |
|orderSn|int|个税查询任务订单号
|cityId|int|城市ID
|img|String|图片base64编码格式,不包含头信息|
|msg|string|错误信息

 **备注** 

 状态码对应的信息说明

  |code|原因|处理方式|
  |:-----  |:-----|-----                           |
  |0 | 成功 | 可以继续接下来的步骤 |
  |-1 | 系统异常 |系统异常导致的错误  |
  |101 |参数错误或缺失  |需检查参数是否缺失或错误  |
  |107 |未找到该订单号  |需检查订单号是否正确  |
  |201 |城市维护中或者不支持  | |
  |202 |个税任务不存在  |确认订单号是否正确 |
  |203 |验证码任务类型不存在  |确定验证码类型是否正确 |
  |207 |获取图形验证码任务失败  | 可重新获取 |
  |208 |获取短信验证码任务失败  |  可重发|

## **2.6**  提交任务查询参数

    
    
**简要描述：** 

- 查询个税任务

**请求URL：** 
- ` IncomeTaxAPI/query  `
  
**请求方式：**
- POST
- Content-Type = application/json
 

**参数：** 


|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|orderSn |是  |string |个税查询任务订单号   |
|params|是|json string|当前查询任务需要的参数 如：{"phone":1111,"code":1111}

 **请求示例**
```json
{
    "orderSn":"7d7cf6f8-8104-4660-bd8c-ec3a93026fg6",
    "params":{
        "ID":"41302619841025456X",
        "password":"123"
    }
}
```


 **返回示例**

```json
{
    "msg":null,
    "code":0,
    "data":{
        "cityId":12,
        "orderSn":"7d7cf6f8-8104-4660-bd8c-ec3a93026fg6"
    }
}
```

 **返回参数说明** 

|参数名|类型|说明|
|:-----  |:-----|-----                           |
|code |int   |错误码 |
|orderSn|string|个税查询订单号
|cityId|int|城市ID
|msg|string|错误信息

 **备注**

   |code|原因|处理方式|
   |:-----  |:-----|----- |
   |0 | 成功 | 可以继续接下来的步骤 |
   |-1 | 系统异常 |系统异常导致的错误  |
   |101 |参数错误或缺失  |需检查参数是否缺失或错误  |
   |107 |未找到该订单号  |需检查订单号是否正确  |
   |201 |城市维护或不支持  |当前城市不支持查询  |
   |202 |个税任务不存在  |需检查订单号是否正确  |
   |204 |任务失败  |  |
   |300 |任务结束  |当抓取任务已经结束且成功，如若继续提交参数会返回该信息  |
   |301 |个税任务正在执行中  |已经提交了任务  |




## **2.7**  查询任务结果
    
**简要描述：** 

- 查询个税任务

!> 禁止轮询该接口，检测到轮询会封对应的appKey


**请求URL：** 
- ` IncomeTaxAPI/getData  `
  
**请求方式：**
- POST
- Content-Type = application/json
 

**参数：** 


|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|orderSn |是  |String |个税查询任务订单号   |


**请求示例**

```json
  {
	"sign":"89D89A1D07E875C649D6A2D01F8E650A",
	"params":{
		"appKey": "88A03809137291F333BF2679AB85850E",
		"timestamp":"1494316515535",
		"token":"f63bbb7a1c1b497387597efda28a1e3c",
		"orderSn":"4243d640-146a-47d7-97b9-a03681fc9bf8"	
	}
  }
```


 **返回示例**

- 当前步骤执行成功，还需要执行下一步，loginParam为登录参数，
```JSON
{
    "msg":null,
    "code":1,
    "data":{
        "data":null,
		"loginParam":[{"note":"用户名指您在注册时自行设置的2-12位英文字母或数字（区分大小写）","name":"account","type":"string"},{"note":"","name":"password","type":"string"}],
        "cityId":12,
        "orderSn":"7d7cf6f8-8104-4660-bd8c-ec3a93026fg6"
    }
}
```

- 登录成功，
```JSON
{
    "msg":null,
    "code":110,
    "data":{
        "data":null,
        "cityId":12,
        "orderSn":"7d7cf6f8-8104-4660-bd8c-ec3a93026fg6"
    }
}
```

- 执行成功


```json
{
    "code":0,
    "msg":"",
    "data":{
        "incometaxData": {
            "data":{
                
                //具体数据结构见附录4.3}
            },
            "cityName":"杭州",
            "cityId":"12",
            "orderId":"158ddhkj-jlhlkmsd-4456465sads",
            "create_date": "2017-10-12 12:26:10"
        }
    }

}
```


- 执行失败


```json
{
    "msg":"参数不正确",
    "code":204,
    "data":{
        "data":null,
		"loginParam":null,
        "cityId":12,
        "orderSn":"7d7cf6f8-8104-4660-bd8c-ec3a93026fg6"
    }
}
```

**返回参数说明** 

|参数名|类型|说明|
|:-----  |:-----|----- |
|code |int   |错误码 |
|orderSn|string|个税查询任务订单号
|cityId|int|城市ID
|msg|string|错误信息
|data|string|数据
|loginParam|json Object|登录参数

 **备注** 

   |code|原因|处理方式|
   |:-----  |:-----|-----|
   |0 | 成功 | 成功并返回数据 |
   |1 | 需要下一步 | 当前步骤执行成功，还需要执行下一步，loginParam为登录参数,需要根据登录参数渲染下一步登录界面 |
   |110 | 登录成功 | 任务已成功提交，等待下一步回调 |
   |105| 初始状态 | 任务状态未改变 |
   |101 |参数错误或缺失  |需检查参数是否缺失或错误  |
   |107 |未找到该订单号  |需检查订单号是否正确  |
   |204 | 任务出错 |错误信息见msg  |
   |-1 | 其他错误 |  |
   |3000 | 验签出错 |具体错误信息解释见4.2  |


## **2.8**  拉取个税证明
    
**简要描述：** 

- 拉取个税证明

!> 禁止轮询该接口，检测到轮询会封对应的appKey

**请求URL：** 
- ` IncomeTaxAPI/getIncomeProve  `
  
**请求方式：**
- POST
- Content-Type = application/json
 
 **参数：** 
 
 
 |参数名|必选|类型|说明|
 |:----    |:---|:----- |-----   |
 |orderSn |是  |String |个税查询任务订单号   |
 
 
 **请求示例**
 
 ```json
   {
 	"sign":"89D89A1D07E875C649D6A2D01F8E650A",
 	"params":{
 		"appKey": "88A03809137291F333BF2679AB85850E",
 		"timestamp":"1494316515535",
 		"token":"f63bbb7a1c1b497387597efda28a1e3c",
 		"orderSn":"4243d640-146a-47d7-97b9-a03681fc9bf8"	
 	}
 	"file":"2018.jpg"   //为空或无此参数则拉取全部年份数据
   }
 ```
 
 
  **返回示例**
  
  - 执行成功
  
  ```json
  {
      "code":0,
      "msg":"获取成功",
      "data":[
             { 
                 "file":"2017.jpg",  //个税年份文件名
                 "data":""       //个税证明图片base64编码格式,不包含头信息
             },
             {
                 "file":"2018.jpg",  //个税年份文件名
                 "data":""       //个税证明图片base64编码格式,不包含头信息
             }
      ]
  
  }
  ```
  
  - 执行失败
  
  
  ```json
  {
      "msg":"未查询到此订单号",
      "code":-1,
      "orderSn":"7d7cf6f8-8104-4660-bd8c-ec3a93026fg6"
  }
  ```
  
  
# **3**  回调通知
## **8.1** 通知参数
>**请求方式：**


>- Method: POST
- Content-Type: application/json
- Charset: UTF-8

**参数：** 


|参数名|必选|类型|说明|
|:----    |:---|:----- |-----   |
|orderSn |是  |String |个税查询任务订单号   |

## **8.2** 通知示例
比如，回调地址为```https://your.url.com/your/server```，那么我方异步回调通
知的请求类似：
```json
{
  "orderSn":"7d7cf6f8-8104-4660-bd8c-ec3a93026fg6"
}
```
当成功收到回调通知后，页面应返回HttpStatus=200

之后，可通过``` 查询任务结果``` 接口查询对应的信息和数据


 


# **4** 附录

## **4.1** 签名算法

签名生成的通用步骤如下：

第一步，设所有发送或者接收到的数据为集合M，将集合M内非空参数值的参数按照参数名ASCII码从小到大排序（字典序），使用URL键值对的格式（即key1=value1&key2=value2…）拼接成字符串stringA。

特别注意以下重要规则：

- 参数名ASCII码从小到大排序（字典序）；
- 如果参数的值为空不参与签名；
- 参数名区分大小写；

第二步，在stringA最后拼接上appSecret得到stringSignTemp字符串，并对stringSignTemp进行MD5运算，再将得到的字符串所有字符转换为大写，得到sign值signValue。

举例：
假设传送的参数如下：
``` json
appKey : 88A03809137291F333BF2689AB85850E,
orderSn : 426ea0df-7f1b-4491-8989-5c130291e892,
timestamp : 1494649888152
token : 0eaeb00afcc4448da724d9179a50abe7
```


第一步：对参数按照key=value的格式，并按照参数名ASCII字典序排序如下：
``` javascript
stringA="appKey=092217B6B52ED02D46EFFFA7CFA20940&orderSn=3e993890-ff08-4af5-bb9b-04fda6dd2b78&timestamp=1494669826683&token=8731de2cd2604f4a856f210703541326";
```
第二步：拼接API密钥：
``` javascript
stringSignTemp=stringA+"&appSecret=192006250b4c09247ec02edce69f6a2d"
sign=MD5(stringSignTemp).toUpperCase()="9A0A8659F005D6984697E2CA0A9CF3B7"
```


## **4.2** 验签接口错误解释


  |code|错误信息|解释及处理方式|
  |:-----  |:-----|-----                           |
  |3000 | 系统异常 |验签服务出错  |
  |3000 |参数错误  |需检查参数是否缺失或错误  |
  |3000 | 时间戳超时 |时间戳的有效期为1分钟，超过视为超时（北京时间）  |
  |3000 |无效的token  |检查token是否正确  |
  |3000 |token已失效  |token过了两小时有效期，或者有了新的token覆盖了旧的token，此处要做好token管理防止并发  |
  |3000 |签名错误  |生成的签名sign与我方根据传来参数计算出的sign不一致，需要检查算法是否正确  |
  |3000 |appKey错误  |检查appKey是否正确  |




## **4.3** 个税数据结构


### 总体结构
!> - JSON键值对除了对象、数组以外，其余键值对的值的数据类型均为String,任何字段若未抓取到数据，默认空字符串





```json
{
    "brief": {
        "ID": "",
        "name": "",
        "amount": 10, //最新月缴税额
        "total": 1000, //缴税总额
        "record_date": "2018-01-01"//最新缴税时间
    },
    "detail": [{
        "record_date": "2018-01-01", //缴税日期或申报日期
        "record_month": "201801", //所属年月
        "amount": 10,    //缴税金额
        "income": 1000, //收入金额
        "tax_type": "基本工资", //缴税项目或收入类型
        "company": "杭州煎饼网络技术有限公司",
        "agency": "XXX税务局" //征收机关
    },
    {
        "record_date": "2018-01-01", //缴税日期或申报日期
        "record_month": "201801", //所属年月
        "amount": 10,    //已缴金额
        "income": 1000, //收入金额
        "tax_type": "基本工资", //缴税项目或收入类型
        "company": "杭州煎饼网络技术有限公司",
        "agency": "XXX税务局" //征收机关
    }],
    "proofs": [ //个税证明文件
        "2018.jpg",
        "2017.jpg"
    ]
}


```


 



 
