const request = require('request');

const config = require('../config');
const SignHost = config.SignHost;



const
	signUrl=SignHost+'/Access/SignValidityCheck',
	tokenUrl=SignHost+'/Access/GetToken',
	orderSnUrl=SignHost+'/Order/GetOrderSn',
    getPartner=SignHost+'/customer/query';
/*获取Token*/
exports.getToken=(params)=>{
	return new Promise((resolve,reject)=>{
		let errMsg = {code: 3000, msg: '签名校验服务出错'};
		let options = {
			url: tokenUrl,
			method: 'POST',
			json: true,
			body: params,
			headers: {
				'content-type': 'application/json'
			}
		};
		request(options, (e, r, b) => {
			if (e) {
				console.error('[func getToken]',params,e);
				resolve(errMsg);
			} else {
				if (b.code == 0) {
					resolve(b);
				} else {
					console.error('[func getToken]',params,b);
					errMsg = {code: 3000, msg:  b.msg};
					resolve(errMsg);
				}

			}
		});
	});
};
/*获取订单号*/
exports.getOrderSn=(params)=>{
	return new Promise((resolve,reject)=>{
		let errMsg = {code: 3000, msg: '签名校验服务出错'};
		let options = {
			url: orderSnUrl,
			method: 'POST',
			json: true,
			body: params,
			headers: {
				'content-type': 'application/json'
			}
		};
		request(options, (e, r, b) => {
			if (e) {
				console.error('[func getOrderSn]',params,e);
				resolve(errMsg);
			} else {
				if (b.code == 0) {
					resolve(b);
				} else {
					console.error('[func getOrderSn]',params,b);
					errMsg = {code: 3000, msg:b.msg};
					resolve(errMsg);
				}

			}
		});
	});
};
/*验证签名*/
exports.signValidation=(params)=>{
	return new Promise((resolve, reject) => {
        params.type=config.signType;
		let options = {
			url: signUrl,
			method: 'POST',
			json: true,
			body: params,
			headers: {
				'content-type': 'application/json'
			}
		};
		request(options, (e, r, vb) => {
			if (e) {
				console.error('[reGJJ][signValidityCheck] signValidityCheck error: ' ,e);
				reject({code:-1,msg:'验签服务器出错'});
			} else {
				if (vb.code === 0) {
					resolve(vb);
				} else {
					reject(vb);
				}
			}
		});
	});
};
/*获取合作方信息*/
exports.getCallbackMap=()=>{
    return new Promise(function (resolve, reject) {
        request({url:getPartner,gzip:true},(e,r,b)=>{
            if(e){
                console.error('getCityList');
                console.error(e);
                return reject(e);
            }else{
                return resolve(b);
            }
        });
    });
};



