'use strict';

const Controller = require('egg').Controller;

class OrderController extends Controller {
  constructor(ctx) {
    super(ctx);

    this.showRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          token: 'string',
          orderSn: {
            type: 'string',
            format: /^(\w{8})-(\w{4})-(\w{4})-(\w{4})-(\w{12})$/,
            message: '订单号格式错误',
          },
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };

    this.fetchRule = {
      signParams: {
        type: 'object',
        rule: {
          sign: 'string',
          params: {
            type: 'object',
            rule: {
              appKey: 'string',
              timestamp: 'string',
              token: 'string',
            },
          },
        }
      },
      cityId: 'string'
    };
  }

  //拉取数据接口
  async partnerShow() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.showRule);
      const { appKey, orderSn } = ctx.request.body.params;
      // await service.signature.signatureCheck(ctx.request.body);
      let data = await service.cache.get({ key: orderSn });
      let result = { code: 2, msg: '任务还在执行或未输入', data: {} };
      if (data) {
        if (data.status === 'success') {
          const result = await service.storage.read(orderSn, appKey);
          ctx.body = {
            code: 0,
            data: result
          };
          return;
        } else if (data.note) {
          result = data.note;
        }
        ctx.body = result;
        return;
      }
    } catch (err) {
      ctx.logger.error('partnerShow', err);
      ctx.status = 200;
      if (err.code == 'invalid_param') {
        return ctx.body = { code: -1, msg: err.message || '' };
      }
      return ctx.body = { code: err.code || -1, msg: err.message || '' };
    }
  }

  //创建订单号接口
  async fetchOrderId() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.fetchRule);
      const { appKey } = ctx.request.body.signParams.params;
      const { cityId } = ctx.request.body;
      const channelType = await ctx.app.redis.get(cityId);
      ctx.app.redis.set(cityId, channelType, "EX", 3600);
      const orderId = await service.signature.createOrderId(ctx.request.body.signParams);
      const taskId = await service.task.create({cityId, channelType});
      await service.order.create({
        orderId,
        taskId,
        cityId,
        notifyUrl: ctx.app.notifyMap.get(appKey) && ctx.app.notifyMap.get(appKey).notifyUrl || '',
        appkey: appKey,
        status: 'init',
        text1: channelType,
      });
      ctx.body = {
        code: 0,
        data: {
          orderSn: orderId
        },
        msg: ''
      }
    } catch (err) {
      ctx.logger.error('fetchOrderId', err);
      ctx.status = 200;
      if (err.code == 'invalid_param') {
        return ctx.body = { code: -1, msg: err.message || '' };
      }
      return ctx.body = { code: err.code || -1, msg: err.message || '' };
    }
  }
}

module.exports = OrderController;
