'use strict';

module.exports = () => {
  const config = exports = {};
  config.debug = true;
  config.logger = {
    dir: '/jianbing/logs/tax_api',
  };

  config.projectRootPath = '/tax_api';

  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST,
      password: process.env.REDIS_PWD,
      db: 0,
    },
  };
  config.taskAPI = {
    host: process.env.TASKAPI_HOST,
    fetchHubsUrl: '',
    createTaskUrl: '/IncomeTax/createItTask',
    fetchCodeUrl: '/IncomeTax/getItCode',
    submitTaskUrl: '/IncomeTax/loginItWeb',
    fetchTaskUrl: '/IncomeTax/getItData',
    cityConfigUrl: '/IncomeTax/getItSetting'
  };

  config.partnerAPI = {
    host: process.env.PARTNERAPI_HOST,
    fetchTheme: '/chaos/theme',
    fetchScripts: '/chaos/partners/scripts',
    fetchAgreements: '/chaos/agreements',
    fetchInfo: '/chaos/partner',
    redisThemePrefix: 'URANUS.IT.PARNTERS.THEME',
    redisScriptsPrefix: 'URANUS.IT.PARNTERS.SCRIPTS',
    redisAgreementsPrefix: 'URANUS.IT.PARNTERS.Agreements',
    redisInfoPrefix: 'URANUS.IT.PARNTERS.Info',
    redisappKeyLimitPrefix: 'URANUS.IT.PARNTERS.Limit',
  };

  config.scriptsAPI = {
    host: process.env.SCRIPTSAPI_HOST,
    fetchScriptsUrl: '/chaos/it/two_dimension_array/queries',
    fetchOneScriptUrl: '/chaos/it/two_dimension_array/info',
    fetchParamsInfoUrl: '/chaos/it/login_param_map',
    fetchQueryButtonUrl: '/chaos/it/query_button',
    fetchHelpUrl: '/chaos/it/help',
    fetchNoticeUrl: '/chaos/it/notice',
    fetchHubSeriptsUrl: '/chaos/it/hubs',
    fetchScriptByCityNameUrl: '/chaos/it/city_scripts',
    redisScriptsKey: 'URANUS.IT.SCRIPTS',
    redisParamsKey: 'URANUS.IT.PARAMS',
    redisScriptListKey: 'URANUS.IT.SCRIPTLIST',
  };

  config.storageAPI = {
    host: process.env.STORAGEAPI_HOST,
    writeUrl: '/data',
    readUrl: '/IncomeTax',
    writeType: 'incomeTax',
    readDataKey: 'incometaxData',
  };

  config.washAPI = {
    host: '',
    washUrl: '',
  };

  config.signatureAPI = {
    host: process.env.SIGNATUREAPI_HOST,
    fetchTokenUrl: '/Access/GetToken',
    fetchOrderIdUrl: '/Order/GetOrderSn',
    signatureUrl: '/Access/SignValidityCheck',
    fetchParnterUrl: '',
    signatureType: 'incomeTax',
    customerUrl: '/customer/query',
  };

  config.lockKeys = {
    fecthHub: 'URANUS.IT.HUBS.LOCK',
    fecteToken: 'URANUS.IT.TOKEN.LOCK',
    token: 'URANUS.IT.TOKEN',
    fecthParnters: 'URANUS.IT.PARNTERS.LOCK',
    taskPrefix: 'URANUS.IT.TASK',
  };

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'model',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_PACHONG_HOST,
      database: process.env.MYSQL_DATA_SERVER_DB_NAME,
      username: process.env.MYSQL_USER,
      password: process.env.MYSQL_PWD,
      port: process.env.MYSQL_PORT,
    }],
  };

  config.callbackUrl = process.env.CALLBACK_URL;

  return config;
};