'use strict';

const Controller = require('egg').Controller;

class ScriptController extends Controller {
  constructor(ctx) {
    super(ctx);
    this.cityListRule = {
      appKey: 'string',
    };
  }

  async partnerScripts() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.cityListRule, ctx.query);
      const { appKey } = ctx.query;
      ctx.logger.info('partnerScripts', appKey)
      let limitScriptsList = false;
      const ret = await service.partner.fetchInfo(appKey);
      if (ret) {
        limitScriptsList = ret.itExcludeScripts;
      } else {
        return ctx.body = { 
          code: -1,
          msg: '无效的appKey'
         };
      }
      let data = await service.scripts.fetchScripts();
      if (limitScriptsList) {
        data = data.filter(item => {
          if (item.state === 'offline' || item.state === 'online') {
            return !(limitScriptsList.includes(item.id));
          }
        });
      }
      ctx.body = {
        code: 0,
        data,
      };
    } catch (err) {
      ctx.logger.info(err);
    }
  }
}

module.exports = ScriptController;
