const path = require('path');
const Koa = require('koa');
const convert = require('koa-convert');
const views = require('koa-views');
const koaStatic = require('koa-static');
const bodyParser = require('koa-bodyparser');
var cors = require('koa-cors');
const util = require('util');
const cleanLog = require('./utils/cheanLog');
const log = require('./utils/log');
const koaLogger = require('koa-logger');



const config = require('./config');
const routers = require('./routers/index');

const app = new Koa();
// app.use((ctx)=>{
//     console.log(ctx.headers);
// })





app.use(cors());


// 配置控制台日志中间件
app.use(koaLogger());

// 配置ctx.body解析中间件
app.use(bodyParser());

// 配置静态资源加载中间件
app.use(koaStatic(
    path.join(__dirname , './public/')
));


app.use(async (ctx, next) => {

    const token = ctx.header.authorization  // 获取jwt
    let payload;
    if (token) {
        try {
            payload = await verify(token.split(' ')[1], secret)  // // 解密，获取payload
            console.log('payload',payload);
            console.log(ctx.path)
            if(config.authData[ctx.path]){
                if(!config.authData[ctx.path].includes(payload.auth)){
                    ctx.status = 403;
                    ctx.body={status:'无权限'}
                    return
                }
            }
        }catch (err){
            console.log(err)
        }

    }
    await next()
})

// 配置服务端模板渲染引擎中间件
app.use(views(path.join(__dirname, './views'), {
    extension: 'ejs'
}));



// 初始化路由中间件
app.use(routers.routes()).use(routers.allowedMethods());

// 监听启动端口
app.listen( config.port )
log.info(`the server is start at port ${config.port}`);
cleanLog();

// console.log(`the server is start at port ${config.port}`);
