const taskAPI=require('../services/taskAPI');

const signAPI=require('../services/ValidationAPI');

const staticVari=require('../services/staticVari');

const MongoIO=require('../services/MongoIO')

const db=require('../utils/db-util');

const log=require('../utils/log');

const config=require('../config');

const OSS = require('ali-oss');

const client = new OSS.Wrapper({
    bucket: '51query',
    accessKeyId: 'LTAI6Glaum6TDzKf',
    accessKeySecret: 'zmNjWhmOD1nIClZ3hoDmGrdNNiBJBi',
    secure: true,
    region: "oss-cn-hangzhou"
})

function throwServiceError(values) {
    this.code=values.code;
    this.message=values.message||values.msg||"";
    this.toString = function() {
        return this.code + this.message
    };
}




module.exports={
    async getCity(ctx){
        try{
            let cityList=staticVari.cityList();
            ctx.body={
                code:0,
                data:cityList
            }
        }catch(err){
            log.error(err)
            ctx.body={
                code:-1,
                msg:""
            }
        }
    },
    async getHelpInfo(ctx){
        try{
            let helpInfo=staticVari.helpInfo();
            ctx.body={
                code:0,
                data:helpInfo
            }
        }catch(err){
            log.error(err)
            ctx.body={
                code:-1,
                msg:""
            }
        }


    },
    async createTask(ctx){
        log.info("createTask",JSON.stringify(ctx.request.body));

        try{
            const {signParams,cityId}=ctx.request.body;
            const appKey=signParams.params.appKey;
            let orderSnObj= await signAPI.getOrderSn(signParams);
            if(orderSnObj.code!==0){
                throw new throwServiceError(orderSnObj)
            }
            let orderSn=orderSnObj.data.orderSn;
            let city=staticVari.getCityById(cityId);
            console.log(city)

            let taskId= await taskAPI.createTask(cityId,city.type);

            let insertParams = {
                taskId: taskId,
                orderId: orderSn,
                appKey: appKey,
                status: 'init',
                note: JSON.stringify({code: 105, msg: '初始状态'}),
                cityId: cityId,
                createDate:new Date().toLocaleString(),
                updateDate: new Date().toLocaleString()
            };

            let insertRet= await db.insertObj([insertParams]);

            if(insertRet.affectedRows!==1){
                throw new throwServiceError({code:-1,msg:"未知错误"})
            }

            staticVari.setOrderSnMap(orderSn,{
                taskId: taskId,
                status: 'init',
                note:{
                    code:105,
                    msg:"init status"
                },
                appKey:appKey,
            });
            ctx.body={
                code: 0,
                orderSn:orderSn,
                msg: "任务创建成功"
            }

        }catch (err){
            log.error("createTask",err,ctx.request.body)
            if(err.hasOwnProperty('code')){
                ctx.body=err
            }else{
                ctx.body={
                    code:-1,
                    msg:'服务器出错'
                }
            }
        }





    },
    async getCode(ctx){
        log.info("getCode",JSON.stringify(ctx.request.body));
        const {orderSn,type}=ctx.request.body;
        try{
            let taskObj= await staticVari.getTaskByOrderSn(orderSn);

            let taskId=taskObj.taskId;

            let params = {taskId,type:type==="code"?"incometax_code":"incometax_phone_code "};

            let CodeObj= await taskAPI.getCode(params);

            if (CodeObj.data && CodeObj.data.taskId) {
                delete CodeObj.data.taskId;
                CodeObj.data.orderSn = orderSn;
            }
            ctx.body=CodeObj


        }catch(err){
            log.error('getCode',err,ctx.request.body);
            if(err.hasOwnProperty('code')){
                ctx.body=err
            }else{
                ctx.body={
                    code:-1,
                    msg:'服务器出错'
                }
            }

        }





    },
    async query(ctx){
        const {orderSn,params}=ctx.request.body;
        log.info("query",ctx.request.body)

        try{
            let taskObj= await staticVari.getTaskByOrderSn(orderSn);

            let queryParams = {
                taskId: taskObj.taskId,
                callbackUrl: config.callbackUrl+"?orderSn="+orderSn,
                data: params
            };

            let queryObj=await taskAPI.submitParams(queryParams);
            if (queryObj.data && queryObj.data.taskId) {
                delete queryObj.data.taskId;
                queryObj.data.orderSn = orderSn;
            }
            ctx.body=queryObj
        }catch(err){
            log.error('query',err,ctx.request.body);
            if(err.hasOwnProperty('code')){
                ctx.body=err
            }else{
                ctx.body={
                    code:-1,
                    msg:'服务器出错'
                }
            }

        }







    },
    async getData(ctx){
        log.info("getData",ctx.request.body)
        try{
            let  orderSn=ctx.request.body.params.orderSn;

            let sign=await signAPI.signValidation(ctx.request.body);

            if(sign.code!==0){
                throw new throwServiceError(sign)
            }


            let taskObj= await staticVari.getTaskByOrderSn(orderSn);

            if(taskObj.status==="success"){

                let data=await MongoIO.readData(orderSn)
                log.info(data);
                ctx.body=data;
            }else{
                taskObj.note.orderSn=orderSn;
                log.info(taskObj.note);

                ctx.body=taskObj.note;

            }



        }catch (err){
            log.error('getData',err,ctx.request.body);
            if(err.hasOwnProperty('code')){
                ctx.body=err
            }else{
                ctx.body={
                    code:-1,
                    msg:'服务器出错'
                }
            }
        }

    },
    async result(ctx){
        try{
            ctx.body="success";
            const {orderSn} =ctx.query;

            if(!orderSn){
                throw new Error({code:"noOrderSn"})
            }
            const {taskId}= ctx.request.body;
            log.info("result",taskId)
            let taskObj=await staticVari.getTaskByOrderSn(orderSn);
            let taskRet= await taskAPI.getData(taskId);
            log.info("taskRet Code:",taskRet.code)
            let updateObj={};

            switch (taskRet.code){
                case -1:
                case 106:
                case 102:
                case 204:
                    taskRet.msg = taskRet.msg.replace(/\'/g, '"').replace(/\ /g, '');
                    staticVari.setOrderSnMap(orderSn,{
                        status:"failed",
                        note:{code:204,msg:taskRet.msg},
                        taskId,
                    });
                    updateObj={
                        status:"failed",
                        note:JSON.stringify({code:204,msg:taskRet.msg}),
                        taskId
                    };
                    break;
                case 1:
                    if (taskRet.data && taskRet.data.taskId) {
                        delete taskRet.data.taskId;
                        taskRet.data.orderSn = orderSn;
                    }   
                    staticVari.setOrderSnMap(orderSn, {
                        status: "next",
                        note: {code: 1, data: taskRet},
                        taskId
                    });
                    updateObj = {
                        status: "next",
                        note: JSON.stringify({code: 1, data: taskRet}),
                        taskId
                    };
                    break;
                case 110:
                    staticVari.setOrderSnMap(orderSn, {
                        status: "query",
                        note: {code: 110, msg:"登录成功"},
                        taskId
                    });
                    updateObj = {
                        status: "query",
                        note: JSON.stringify({code: 110, msg:"登录成功"}),
                        taskId,
                        updateDate:new Date().toLocaleString()
                    };
                    break;
                case 0:
                    taskRet.cityId = Number(taskRet.data.cityId);
                    taskRet.cityName = staticVari.getCityById(taskRet.data.cityId).name;
                    taskRet.taskId = taskRet.data.taskId;
                    taskRet.data= JSON.parse(taskRet.data.data);
                    taskRet.orderSn=orderSn;
                    taskRet.orderId=orderSn;
                    taskRet.appKey = taskObj.appKey;
                    taskRet.serviceType = 'incomeTax';
                    delete taskRet.code;
                    delete taskRet.msg;
                    let InsertMongo=await MongoIO.dataStorage(taskRet)
                    if(InsertMongo.code===0||InsertMongo.code==="0"){
                        staticVari.setOrderSnMap(orderSn, {
                            status: "success",
                            note: {code: 0, msg:"success"},
                            taskId,

                        });
                        updateObj = {
                            status: "success",
                            note: JSON.stringify({code: 0, msg:"success"}),
                            taskId,
                            updateDate:new Date().toLocaleString()

                        };
                    }else{
                        log.error("InsertMongo",JSON.stringify(taskRet))
                        staticVari.setOrderSnMap(orderSn, {
                            status: "failed",
                            note: {code: -1, msg:"数据存储出错"},
                            taskId
                        });
                        updateObj = {
                            status: "failed",
                            note: JSON.stringify({code: -1, msg:"数据存储出错"}),
                            taskId,
                            updateDate:new Date().toLocaleString()
                        };
                    }

                    break;

                default:
                    log.warn('taskAPI.getData',taskRet)
                    break
            }

            let upDataDb=await db.updateData([updateObj,orderSn]);
            if(upDataDb.affectedRows===1){
                if(updateObj.hasOwnProperty('status')){
                    console.log("WHYUYYYYYYYYYYYYYYY")
                    console.log("WHYUYYYYYYYYYYYYYYY",taskObj.appKey,{orderSn})
                    staticVari.ServerSideCall(taskObj.appKey||"",{orderSn})
                }
            }

        }catch (err){
            console.error(err)
        }


    },
    async getIncomeProve(ctx) {
        log.info("getIncomeProve", ctx.request.body)
        try {
            let orderSn = ctx.request.body.params.orderSn;

            let sign = await signAPI.signValidation(ctx.request.body);

            if (sign.code !== 0) {
                throw new throwServiceError(sign)
            }

            let taskObj = await staticVari.getH5TaskByOrderSn(orderSn);

            if (taskObj.length > 0) {

                let data = await getpage(orderSn,taskObj[0].taskId, ctx.request.body.file);

                ctx.body = data;
            } else {
                taskObj = await staticVari.getapiTaskByOrderSn(orderSn);

                if (taskObj[0].status === "success") {

                    let data = await getpage(orderSn,taskObj[0].taskId, ctx.request.body.file);

                    ctx.body = data;

                } else {
                    ctx.body = {
                        code: -1,
                        msg: "未查询到此订单号",
                        orderSn:orderSn
                    };
                }
            }
        } catch (err) {
            log.error('getIncomeProve', err, ctx.request.body);
            if (err.hasOwnProperty('code')) {
                ctx.body = err
            } else {
                ctx.body = {
                    code: -1,
                    msg: '服务器出错'
                }
            }
        }
    }
};

async function getpage(orderSn,taskId, file) {
    try {
        if (file != undefined && /[0-9]{4}/.test(file)) {
            return await client.get(`incometaxProve/${taskId}/${file}`).then(files => {
                return {code: 0, msg: '获取成功', data: {file: file, data: (new Buffer(files.content).toString('base64'))}};
            }).catch(error =>{
                log.error("getpage", error);
                return {code: -1, msg: '未查询到本年信息', orderSn: orderSn};
            })
        } else {
            let result = await client.list({
                prefix: `incometaxProve/${taskId}/`,
                delimiter: '/'
            });
            let data = [];
            if (result.objects === undefined) {
                return {code: 101, msg: "未查询到此任务", orderSn: orderSn};
            } else {
                result.objects.map(function (obj, index) {
                    data[index] = client.get(obj.name).then(file => {
                        let rgx = new RegExp(`incometaxProve/${taskId}/`, 'g')
                        return {year: obj.name.replace(rgx, ''), data: (new Buffer(file.content).toString('base64'))};
                    })
                });
                let results = await Promise.all(data);
                return {code: 0, msg: '获取成功', data: results};
            }
        }
    } catch (e) {
        log.error("getpage", e);
        return {code: -1, msg: "系统错误", data: ""};
    }
}