const request=require('request')

const db=require('./../utils/db-util');

const signAPI=require('./ValidationAPI')
const taskAPI=require('./taskAPI');

const log=require('../utils/log');



let cityList=[];

let orderSnMap = new Map();

let CustomerMap= new Map();

let cityMap=new Map();

let helpInfo=[];

let newCityMap=new Map()


function getCityList() {


    taskAPI.getCityList("gsgj").then(Row=>{
        Row=JSON.parse(Row);
        Row.data.map(Prov=>{
            Prov.citys.map(city=>{
                newCityMap.set(String(city.id),city)
            })
        });
        taskAPI.getCityList("51gs").then(Row51=>{
            Row51=JSON.parse(Row51);
            cityList=[];
            Row51.data.map(Prov=>{
                let newProv = { provinceName: Prov.provinceName, citys: [] };
                Prov.citys.map(city=>{
                    city.type="51gs";
                    if(city.state===-1&&newCityMap.get(String(city.id))&&newCityMap.get(String(city.id)).state!==-1){
                        city=newCityMap.get(String(city.id))
                        city.type="gsgj";
                        console.log(city)
                    }
                    cityMap.set(String(city.id),city)
                    if (city.state === 1 || city.state === -1) {
                        newProv.citys.push({
                            province: city.province,
                            name: city.name,
                            id: city.id,
                            state: city.state,
                            queryParam: city.queryParam
                        });
                    }


                })
                cityList.push(newProv)
            });
        })
    }).catch(err=>{
        log.error(err)
    })
}

function getHelpInfo() {
    db.QueryHelpInfo([['cid','city','help']]).then(Rows=>{
        if(Rows.length>0){
            helpInfo=Rows;
        }else{
            log.error("getHelpInfo")
        }
    }).catch(err=>{
        log.error(err)
    })
}

function getCustomer() {
    signAPI.getCallbackMap().then(b=>{
        b = JSON.parse(b);
        if (b.code === 0) {
            b.data.customerList.map(customer => {
                if ('callBackUrl' in customer) {
                    CustomerMap.set(customer.appKey, customer.callBackUrl);
                }
            });
        }
    }).catch(err=>{
        cosnole.error(err)
    })

}


function getCustomerByAppKey(appKey) {

    if(CustomerMap.has(appKey)){
        return CustomerMap.get(appKey)
    }else{
        log.error("noCus",appKey)
        return ""
    }
}



getHelpInfo()
getCityList();
getCustomer();
setInterval(function () {
    getCityList();
    getCustomer();
    getHelpInfo();
},1000*60*3);

function RCityList() {
    return cityList
}

function RHelpInfo() {
    return helpInfo
}


function getTaskByOrderSn(orderSn) {
    return new Promise((resolve, reject) => {
        if (orderSnMap.has(orderSn)) {
            return resolve(orderSnMap.get(orderSn));
        } else {
            db.QueryFromStatus([['status', 'note', 'appKey', 'taskId'], orderSn]).then(Rows => {
                if (Rows.length > 0) {
                    Rows[0].note = JSON.parse(Rows[0].note);
                    resolve(Rows[0]);
                } else {
                    reject();
                }
            });
        }
    });
}

async function getapiTaskByOrderSn(orderSn) {
    try {
        let rows = await db.QueryFromStatus([['status', 'note', 'appKey', 'taskId'], orderSn]);
        log.info("getapiTaskByOrderSn", rows);
        return rows;
    } catch (e) {
        log.error("getapiTaskByOrderSn", e);
        return [];
    }
}

async function getH5TaskByOrderSn(orderSn) {
    try {
        let rows = await db.QueryFromH5Status([['status', 'appKey', 'taskId'], orderSn]);
        log.info("getH5TaskByOrderSn", rows);
        return rows;
    } catch (e) {
        log.error("getH5TaskByOrderSn", e);
        return [];
    }
}

function setOrderSnMap(key, values) {
    values.time = new Date().getTime();

    if (orderSnMap.has(key)) {
        orderSnMap.get(key).status = values.status;
        orderSnMap.get(key).note = values.note;
        orderSnMap.get(key).taskId = values.taskId;
        orderSnMap.get(key).time = values.time;
    } else {
        orderSnMap.set(key, values)
    }
    
}


function ServerSideCall(appKey,data) {
    let url=getCustomerByAppKey(appKey);
    return new Promise((resolve, reject) => {
        let options = {
            url: url,
            method: 'POST',
            json: true,
            body: data,
            headers: {
                'content-type': 'application/json'
            }
        };
        request(options, (e, r, b) => {
            if (e) {
                log.error('callbackParams' + JSON.stringify(options));
                log.error(e);
                resolve();
            } else {
                log.info('callbackParams' + JSON.stringify(options));
                log.info(b);
                resolve();
            }

        });
    });
}


function getCityById(centerId) {
    if(cityMap.has(String(centerId))){
        return cityMap.get(String(centerId))
    }else{
        log.error("centerId",centerId,cityMap)
        return {}
    }
}






exports.cityList=RCityList;
exports.helpInfo=RHelpInfo;

exports.setOrderSnMap=setOrderSnMap;

exports.getTaskByOrderSn = getTaskByOrderSn;
exports.getH5TaskByOrderSn = getH5TaskByOrderSn;
exports.getapiTaskByOrderSn = getapiTaskByOrderSn;

exports.getCustomerByAppKey=getCustomerByAppKey;

exports.ServerSideCall=ServerSideCall;
exports.getCityById=getCityById;
