const fs = require('fs');
const moment = require('moment');
const schedule = require('node-schedule');
const log = require('./log');

function getFileName(path) {
    return new Promise((resolve, reject) => {
        fs.readdir(path, (err, files) => {
            if (err) {
                reject(err);
            } else {
                resolve(files);
            }
        });
    });
}

function removeFile(path) {
    return new Promise((resolve, reject) => {
        fs.unlink(path, (err) => {
            if (err) {
                reject(err);
            } else {
                resolve();
            }
        });
    });
}

function removeOverdueLogFile(eachFileName) {
    let result = /IITAPI-(\d{8}).log/.exec(eachFileName);
    if (null !== result) {
        let date = moment(result[1], 'YYYYMMDD');
        if (date.isValid() && moment().subtract(3, 'd').isAfter(date)) {
            try {
                removeFile(`./logs/${eachFileName}`);
                log.info('删除三天前日志');
                log.info(`${eachFileName}`);
            } catch(e) {
                log.error('删除日志失败');
                log.error(e);
            }
        }
    }
}

async function cleanLogFile() {
    let filesName = await getFileName('./logs');
    for (let eachFileName of filesName) {
        removeOverdueLogFile(eachFileName);
    }
}

function cleanLogEveryDay() {
    schedule.scheduleJob('00 00 4 * * *', cleanLogFile);
}


module.exports = cleanLogEveryDay;