const config = require('./../config');
const mysql = require("mysql")

const pool = mysql.createPool(config.database)

let query = function( sql, values ) {

    return new Promise(( resolve, reject ) => {
        pool.getConnection(function(err, connection) {
            if (err) {
                resolve( err )
            } else {
                connection.query(sql, values, ( err, rows) => {
                    if ( err ) {
                        reject( err )
                    } else {
                        resolve( rows )
                    }
                    connection.release()
                })
            }
        })
    })

};




let selectUser = function( values ) {
    let  _sql =  "SELECT ?? FROM adminuser  WHERE ?? = ?"
    return query( _sql, values )
}


let insertUser = function(  values ) {
    let _sql = "INSERT INTO  adminuser set ?"
    return query( _sql, values )
}

let insertObj = function(  values ) {
    let _sql = "INSERT INTO  iit_status set ?"
    return query( _sql, values )
}


let getCity=function (values) {
    let  _sql =  "SELECT ?? FROM adminuser  "
    return query( _sql, values )
}


let updateData = function(  values ) {
    let _sql = "UPDATE iit_status SET ? WHERE orderId = ?"
    return query( _sql, values )
}

let selectPartnerList = function( values ) {
    let  _sql =  "SELECT ?? FROM admin_partner "
    return query( _sql, values )
};

let QueryFromStatus = function (values) {
    let _sql = "SELECT ?? FROM iit_status WHERE orderId = ?"
    return query( _sql, values )
};

let QueryHelpInfo = function (values) {
    let _sql = "SELECT ?? FROM iit_help "
    return query( _sql, values )
};

let QueryFromH5Status = function (values) {
    let _sql = "SELECT ?? FROM iith5_status WHERE orderId = ? and `status`= 'success'"
    return query( _sql, values )
};





module.exports = {
    query,
    selectUser,
    insertUser,
    selectPartnerList,
    getCity,
    insertObj,
    updateData,
    QueryFromStatus,
    QueryHelpInfo,
    QueryFromH5Status
}
