const request = require('request');

const config = require('../config');
const TaskHost = config.TaskHost;
const newTaskHost = config.newTaskHost;
const log=require('../utils/log');

// const staticVari=require('./staticVari');



const
    cityListUrl = TaskHost + '/IncomeTax/getItSetting',
    createTaskUrl = TaskHost + '/IncomeTax/createItTask',
    getCodeUrl = TaskHost + '/IncomeTax/getItCode',
    submitParamsUrl = TaskHost + '/IncomeTax/loginItWeb',
    getDataUrl = TaskHost + '/IncomeTax/getItData';

const
    cityListUrlNew = newTaskHost + '/IncomeTax/getItSetting',
    createTaskUrlNew = newTaskHost + '/IncomeTax/createItTask',
    getCodeUrlNew = newTaskHost + '/IncomeTax/getItCode',
    submitParamsUrlNew = newTaskHost + '/IncomeTax/loginItWeb',
    getDataUrlNew = newTaskHost + '/IncomeTax/getItData';




/*获取城市列表*/
exports.getCityList=(type)=> {
	return new Promise(function (resolve, reject) {
		request({url:type==="gsgj"?cityListUrlNew:cityListUrl,gzip:true},(e,r,b)=>{
			if(e){
				log.error('getCityList');
				log.error(e);
				return reject(e);
			}else{
				if(b){
                    return resolve(b);
				}else{
                    log.error(r.statusCode);
				}

			}
		});
	});
};

/*创建任务*/
exports.createTask=(cityId,type)=> {
	let errMsg = {code: 500, msg: '创建任务服务出错'};
	return new Promise(function (resolve, reject) {
		let form_data = {cityId: cityId};

		let options = {
			url: type==="gsgj"?createTaskUrlNew:createTaskUrl,
			method: 'POST',
			json: true,
			body: form_data,
			headers: {
				'content-type': 'application/json'
			}
		};
		request(options, (e, r, b) => {
			if (e) {
                log.error(e);
                log.error('[createTask err]',JSON.stringify(options));
				reject(errMsg);
			} else {
				if (b&&b.code === 0) {
					resolve(b.data.taskId);
				} else {
					console.log('createTask err' , JSON.stringify(options),JSON.stringify(b));
					reject(b);
				}
			}
		});
	});

};

/*获取验证码*/
exports.getCode=(params)=>{
	return new Promise((resolve,reject)=>{
		let errMsg={code:-1,msg:'服务器出错'};
		let options = {
			url: params.taskId.length>20?getCodeUrlNew:getCodeUrl,
			method: 'POST',
			json: true,
			body: params,
			headers: {
				'content-type': 'application/json'
			}
		};
		request(options, (e, r, b) => {
			
			if (e) {
				console.error('getCode',e);
				resolve(errMsg);
			} else {
				if (b&&b.code === 0) {
					resolve(b);
                    log.info(JSON.stringify(options))
					log.info(b)
				} else {
					log.error('[getImgCode]ErrReq:' + JSON.stringify(params) + 'Res:' + JSON.stringify(b));
					resolve(b);
				}
			}
		});
	});
};

/*提交参数*/
exports.submitParams=(params) =>{
	let errMsg = {code: -1, msg: '服务器错误'};
	return new Promise(function (resolve, reject) {
		let options = {
			url: params.taskId.length>20?submitParamsUrlNew:submitParamsUrl,
			method: 'POST',
			json: true,
			body: params,
			headers: {
				'content-type': 'application/json'
			}
		};
		log.info(JSON.stringify(options))
		request(options, (e, r, b) => {
			if (e) {
				log.error('[GJJ][/ajax/commitParams]提交任务请求失败');
				log.error(e);
				resolve(errMsg);
			} else {
				if (b&&b.code === 0) {
					resolve(b);
				} else {
					console.error('提交任务出错Req：+' + JSON.stringify(params) + ' Res: ' + JSON.stringify(b));
					resolve(b);
				}
			}
		});
	});

};

/*拉取数据*/
exports.getData=(taskId)=>{
	return new Promise((resolve,reject)=>{
		let options = {
			url:taskId.length>20?getDataUrlNew:getDataUrl,
			method: 'POST',
			json: true,
			body: { taskId: taskId },
			headers: {
				'content-type': 'application/json'
			}
		};
		request(options, (e, r, b) => {
			if (e) {
				console.error(e);
				reject(e);
			} else {
				if(b){
                    resolve(b);
				}else{
					reject(r.statusCode)
				}

			}
		});
	});
};



