'use strict';

const Controller = require('egg').Controller;

class OrderController extends Controller {
  constructor(ctx) {
    super(ctx);

    this.showRule = {
      sign: 'string',
      params: {
        type: 'object',
        rule: {
          token: 'string',
          orderSn: {
            type: 'string',
            format: /^(\w{8})-(\w{4})-(\w{4})-(\w{4})-(\w{12})$/,
            message: '订单号格式错误',
          },
          appKey: 'string',
          timestamp: 'string',
        },
      },
    };

    this.fetchRule = {
      signParams: {
        type: 'object',
        rule: {
          sign: 'string',
          params: {
            type: 'object',
            rule: {
              appKey: 'string',
              timestamp: 'string',
              token: 'string',
            },
          },
        }
      },
      cityId: 'string'
    };
  }

  //拉取数据接口
  async partnerShow() {
    const { ctx, service } = this;
    try {
      ctx.validate(this.showRule);
      const { appKey, orderSn } = ctx.request.body.params;
      await service.signature.signatureCheck(ctx.request.body);
      let data = await service.cache.get({ key: orderSn });
      let result = '任务还在执行或未输入';
      if (data) {
        if (data.status === 'success') {
          const result = await service.storage.read(orderSn, appKey);
          ctx.body = {
            code: 0,
            data: result
          };
          return;
        } else if (data.note) {
          result = data.note.message;
        }
        ctx.body = {code: -1, msg: result};
        return;
      }
    } catch (err) {
      ctx.logger.error('partnerShow', err);
      ctx.status = 200;
      if (err.code == 'invalid_param') {
        return ctx.body = { code: -1, msg: err.message || '' };
      }
      return ctx.body = { code: err.code || -1, msg: err.message || '' };
    }
  }

  //创建订单号接口
  async fetchOrderId() {
    const { ctx, service } = this;
    try {
      const { appKey, cityId } = ctx.params;
      // const appKeyInfo = await service.partner.fetchInfo(appKey);
      // ctx.logger.info(appKey, ',appKeyInfo,', appKeyInfo);
      // if (!(appKeyInfo && appKeyInfo.valid === true && appKeyInfo.enableIt === true)) {
      //     return ctx.fail('未开通此服务');
      // }

      const orderId = ctx.helper.getUuid();
      const taskId = await service.task.create({cityId});
      await service.order.create({
        orderId,
        taskId,
        cityId,
        notifyUrl: ctx.app.notifyMap.get(appKey) && ctx.app.notifyMap.get(appKey).notifyUrl || '',
        appkey: appKey,
        status: 'init',
      });
      ctx.body = {
        code: 0,
        data: {
          orderSn: orderId
        },
        msg: ''
      }
    } catch (err) {
      ctx.logger.error('fetchOrderId', err);
      ctx.status = 200;
      if (err.code == 'invalid_param') {
        return ctx.body = { code: -1, msg: err.message || '' };
      }
      return ctx.body = { code: err.code || -1, msg: err.message || '' };
    }
  }

  //获取帮助配置接口
  async help(){
    const { ctx, service } = this;
    const { cityId } = ctx.params;
    const cityName = await await service.scripts.fetchScriptName(cityId);
    const helpData = await service.scripts.fetchHelp(cityId);
    let helpInfo = [];
    for(let item of helpData[0].help_list){
      helpInfo.push({
        desc: item.content,
        link: {
          label: item.button_name,
          url: item.button_url,
        },
      })
    }
    ctx.success({
      code: "0",
      data: {
        cityId,
        city: cityName,
        help: helpInfo
      }
    });
  }
}

module.exports = OrderController;
