'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { router, controller } = app;

  const taxRouter = router.namespace(app.config.projectRootPath);

  taxRouter.get('/getCity', controller.task.cityConfigs);// 获取城市基础配置项

  taxRouter.get('/getorderSn/:appKey/:cityId', controller.order.fetchOrderId);// 合作方获取订单号

  taxRouter.post('/getCode', controller.task.fetchCapture);// 获取验证码

  taxRouter.post('/query', controller.task.submit);// 提交任务查询参数

  taxRouter.post('/getToken', controller.token.partnerCreate);// 合作方创建token

  taxRouter.post('/getData', controller.order.partnerShow);// 合作方获取订单数据

  taxRouter.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外

  taxRouter.get('/helpInfo/:cityId', controller.order.help);// 获取帮助信息
};
