'use strict';

const Service = require('egg').Service;

class TaskService extends Service {
    constructor(ctx) {
        super(ctx);
        const {config} = this;
        const {taskAPI, LOCK_KEY} = config;
        this.baseURL = taskAPI.host;
        this.newbaseURL = taskAPI.newhost;
        this.createTaskUrl = taskAPI.createTaskUrl;
        this.submitTaskUrl = taskAPI.submitTaskUrl;
        this.fetchCodeUrl = taskAPI.fetchCodeUrl;
        this.fetchTaskUrl = taskAPI.fetchTaskUrl;
        this.cityConfigUrl = taskAPI.cityConfigUrl;
        this.LOCK_KEY = LOCK_KEY;
    }


    _request(url, opts) {
        const {ctx, baseURL} = this;
        url = `${baseURL}${url}`;
        opts = {
            charset: 'utf-8',
            timeout: ['30s', '30s'],
            dataType: 'json',
            contentType: 'json',
            ...opts,
        };
        ctx.logger.info('_request', url);
        return ctx.curl(url, opts);
    }

    _checkSuccess(result) {
        if (result.status !== 200) {
            const errorMsg = result.data && result.data.error_msg ? result.data.error_msg : 'unknown error';
            this.ctx.throw(result.status, errorMsg);
        }
        if (result.data.code !== 0) {
            this.ctx.throw(400, {message: result.data.msg, code: result.data.code});
        }
    }

    async create({cityId}) {
        const {createTaskUrl, ctx} = this;
        const result = await this._request(createTaskUrl, {
            method: 'post',
            data: {cityId},
        });
        ctx.logger.info(`【Task】create ${createTaskUrl} cityId: ${cityId} result:`, JSON.stringify(result.data));
        this._checkSuccess(result);
        return result.data.data.taskId;
    }

    async fetchCapture({taskId, type}) {
        const {fetchCodeUrl, ctx} = this;
        const result = await this._request(fetchCodeUrl, {
            method: 'post',
            data: {
                taskId,
                type,
            },
        });
        ctx.logger.info(`【Task】fetchCapture ${fetchCodeUrl} params`, JSON.stringify({
            taskId,
            type,
        }), result.data.code);
        this._checkSuccess(result);
        return result.data.data;
    }

    async submit(data) {
        const {submitTaskUrl, ctx} = this;
        const result = await this._request(submitTaskUrl, {
            method: 'post',
            data,
        });
        ctx.logger.info(`【Task】submit ${submitTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data));
        this._checkSuccess(result);
        return result;
    }

    async fetchTask(data) {
        const {fetchTaskUrl, ctx} = this;
        const result = await this._request(fetchTaskUrl, {
            method: 'post',
            data,
        });
        ctx.logger.info(`【Task】fetchTask ${fetchTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data));
        return result.data;
    }

    async getCityList() {
        const {cityConfigUrl, ctx} = this;
        let cityLists = [];//对外城市列表

        const ret = await this._request(cityConfigUrl, {method: 'get'});
        ctx.logger.info(`【Task】getCityList params 51gs`, ret.status, ret.data.data.length);
        this._checkSuccess(ret);
        ret.data.data.map(Prov => {
            let newProv = {provinceName: Prov.provinceName, citys: []};
            Prov.citys.map(city => {
                newProv.citys.push({
                    province: city.province,
                    name: city.name,
                    id: city.id,
                    state: city.state,
                    queryParam: city.queryParam
                });
            });
            cityLists.push(newProv);
        });
        return cityLists;
    }
}

module.exports = TaskService;