const request = require('request');
const config = require('../config');
const StorageHost = config.StorageHost;

const
    setStorageUrl=StorageHost+'/data',
    getStorageUrl=StorageHost+'/IncomeTax/';



exports.dataStorage=(params)=>{
	return new Promise(function (resolve, reject) {
		let options = {
			url: setStorageUrl,
			method: 'POST',
			json: true,
			body: params,
			headers: {
				'content-type': 'application/json'
			}
		};
		request(options, (e, r, b) => {
			if (e) {
				return resolve({ code: -1, msg: '数据库服务器出错'});
			} else {
				return resolve(b);
			}
		});
	});
};

exports.readData=(orderSn)=>{
	return new Promise(function (resolve, reject) {
		let url =getStorageUrl + orderSn;
        let options = {
            url: url,
            gzip: true
        };
        request(options, (e, r, b) => {
            if (e) {
                return resolve({ code: -1, msg: '数据库服务器出错'});
            } else {
                return resolve(b);
            }
        });
	});
};