'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { partnerAPI } } = this;
    this.partnerAPI = partnerAPI;
  }

  async fetchInfo(appKey){
    const { ctx, partnerAPI: { fetchInfo, host, redisInfoPrefix } } = this;
    if (appKey) {
      const data = await this.app.redis.get(redisInfoPrefix + appKey);
      ctx.logger.info('【Scripts】fetchInfo redis data', redisInfoPrefix + appKey, 'result:', data);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.info('【Scripts】fetchInfo redis err', redisInfoPrefix + appKey, 'result:', data, err);
          await this.app.redis.del(redisInfoPrefix + appKey);
        }
      }
    }

    const ret = await ctx.curl(`${host + fetchInfo}`, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
      data: {
        appKey
      }
    });
    ctx.logger.info(`【Partner】 fetchTheme ${host + fetchInfo}?appKey=${appKey}`, ret.data);
    if (ret.status === 200 && ret.data && ret.data.length > 0 && ret.data[0].appKey === appKey) {
      await this.app.redis.set(redisInfoPrefix + appKey, JSON.stringify(ret.data[0]), 'EX', 300);
    }
    return ret.data[0];
  }

  async notice(order) {
    const { ctx } = this;
    const { orderId, notifyUrl, notice } = order;
    if (notifyUrl && notice !== '1') {
      const ret = await ctx.curl(notifyUrl, {
        charset: 'utf-8',
        timeout: ['30s', '30s'],
        contentType: 'json',
        method: 'POST',
        data: {
          orderSn: orderId
        },
      }
      )
      ctx.logger.info(`【Partner】 notice ${notifyUrl}`, 'orderId:', orderId, 'result:', ret.status, JSON.stringify(ret.data));
      if (ret.status == 200) {
        await order.update({ notice: '1' });
      }
    }
    return;
  }

  async appKeyLimit(appKey) {
    const { ctx, partnerAPI: { redisappKeyLimitPrefix } } = this;
    let data = await this.app.redis.get(redisappKeyLimitPrefix);
    if (data) {
      data = JSON.parse(data);
      if (data.includes(appKey)) {
        let limit = await this.app.redis.get(redisappKeyLimitPrefix + appKey);
        if (limit) {
          limit = JSON.parse(limit);
          if (limit.currentCount >= limit.limitCount) {
            ctx.throw(422, { message: 'appKey查询数量超过限制,请联系技术人员' });
          } else {
            // limit.currentCount++;
            // await this.app.redis.set(redisappKeyLimitPrefix + appKey, JSON.stringify({ currentCount: limit.currentCount, limitCount: limit.limitCount }), 'EX', 300);
            await ctx.model.query('UPDATE node_limit set currentCount = currentCount + 1  where appKey = ?', {
              type: 'UPDATE',
              replacements: [appKey],
            });
          }
        }
      }
    } else {
      const dbRes = await ctx.model.NodeLimit.findAll({
        attributes: ['appKey', 'currentCount', 'limitCount'],
        where: { type: 'tax' },
      });
      if (dbRes) {
        const appKeyArray = [];
        for (const item of dbRes) {
          const { appKey, currentCount, limitCount } = item;
          appKeyArray.push(appKey);
          await this.app.redis.set(redisappKeyLimitPrefix + appKey, JSON.stringify({ currentCount, limitCount }), 'EX', 300);
        }
        await this.app.redis.set(redisappKeyLimitPrefix, JSON.stringify(appKeyArray), 'EX', 300);
        if (appKeyArray.includes(appKey)) {
          await ctx.model.query('UPDATE node_limit set currentCount = currentCount + 1  where appKey = ?', {
            type: 'UPDATE',
            replacements: [appKey],
          });
        }
      }
    }
  }
}

module.exports = PartnerService;
