'use strict';

module.exports = {
    schedule: {
        interval: '3m', // 5分钟间隔
        type: 'all', // 所有woker
        immediate: true,
    },

    async task(ctx) {
        try {
            const { host, customerUrl } = ctx.app.config.signatureAPI;
            const notifyMap = new Map();
            ctx.logger.info('host',host, 'customerUrl', customerUrl)
            const ret = await ctx.curl(host + customerUrl, {
                charset: 'utf-8',
                timeout: ['30s', '30s'],
                dataType: 'json',
                contentType: 'json'
            });
            ctx.logger.info('notifyUrlCode', JSON.stringify(ret.data.code));
            if (ret.data.code === 0) {
                ret.data.data.customerList.map(customer => {
                    if ('callBackUrl' in customer) {
                        notifyMap.set(customer.appKey, { notifyUrl: customer.callBackUrl });
                    }
                });
            }
            ctx.app.notifyMap = notifyMap;
        } catch (e) {
            ctx.logger.error('【schedule/notifyUrlTask】catch error:', JSON.stringify(e));
        }
    }
};