'use strict';

const Service = require('egg').Service;

class TaskService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    const { taskAPI, LOCK_KEY } = config;
    this.baseURL = taskAPI.host;
    this.newbaseURL = taskAPI.newhost;
    this.createTaskUrl = taskAPI.createTaskUrl;
    this.submitTaskUrl = taskAPI.submitTaskUrl;
    this.fetchCodeUrl = taskAPI.fetchCodeUrl;
    this.fetchTaskUrl = taskAPI.fetchTaskUrl;
    this.LOCK_KEY = LOCK_KEY;
  }


  _request(url, type, opts) {
    const { ctx, baseURL, newbaseURL } = this;
    url = (type === 'gsgj') ? `${newbaseURL}${url}` : `${baseURL}${url}`;
    opts = {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      contentType: 'json',
      ...opts,
    };
    ctx.logger.info('_request', type, JSON.stringify(opts));
    return ctx.curl(url, opts);
  }

  _checkSuccess(result) {
    if (result.status !== 200) {
      const errorMsg = result.data && result.data.error_msg ? result.data.error_msg : 'unknown error';
      this.ctx.throw(result.status, errorMsg);
    }
    if (result.data.code !== 0) {
      this.ctx.throw(400, { message: result.data.msg, code: result.data.code });
    }
  }

  async create(data) {
    const { createTaskUrl, ctx } = this;
    const result = await this._request(createTaskUrl, ctx.app.channelType, {
      method: 'post',
      data: { cityId: data },
    });
    ctx.logger.info(`【Task】create ${createTaskUrl} cityId: ${data} result:`, JSON.stringify(result.data));
    ctx.logger.info('channelType', ctx.app.channelType);
    this._checkSuccess(result);
    return result.data.data.taskId;
  }

  async fetchCapture({ taskId, type }) {
    const { fetchCodeUrl, ctx } = this;
    let channelType = taskId.length > 20 ? 'gsgj' : '51gs';
    const result = await this._request(fetchCodeUrl, channelType, {
      method: 'post',
      data: {
        taskId,
        type,
      },
    });
    ctx.logger.info(`【Task】fetchCapture ${fetchCodeUrl} params`, JSON.stringify({
      taskId,
      type,
    }), result.data.code);
    this._checkSuccess(result);
    return result.data.data;
  }

  async submit(data) {
    const { submitTaskUrl, ctx } = this;
    let channelType = data.taskId.length > 20 ? 'gsgj' : '51gs';
    const result = await this._request(submitTaskUrl, channelType, {
      method: 'post',
      data,
    });
    ctx.logger.info(`【Task】submit ${submitTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data));
    this._checkSuccess(result);
    return result;
  }

  async fetchTask(data) {
    const { fetchTaskUrl, ctx } = this;
    let channelType = data.taskId.length > 20 ? 'gsgj' : '51gs';
    const result = await this._request(fetchTaskUrl, channelType, {
      method: 'post',
      data,
    });
    ctx.logger.info(`【Task】fetchTask ${fetchTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data));
    return result.data;
  }
}

module.exports = TaskService;
