'use strict';

module.exports = {
    schedule: {
        interval: '30m', // 5分钟间隔
        type: 'all', // 所有woker
        immediate: true,
    },
    async task(ctx) {
        try {
            const {host, newhost, cityConfigUrl} = ctx.app.config.taskAPI;
            let cityLists = [];//对外城市列表
            let cityTypeLists = [];//不对外城市列表，含渠道（51/管家）
            let newCityMap = new Map();
            let cityMap=new Map();

            const newret = await ctx.curl(newhost + cityConfigUrl, {
                charset: 'utf-8',
                timeout: ['30s', '30s'],
                dataType: 'json',
                contentType: 'json',
                gzip: true
            });
            ctx.logger.info('newhost', newhost + cityConfigUrl, JSON.stringify(newret.data.code));
            if (newret.data.code === 0) {
                newret.data.data.map(Prov => {
                    Prov.citys.map(city => {
                        newCityMap.set(String(city.id), city)
                    })
                })
            }

            const ret = await ctx.curl(host + cityConfigUrl, {
                charset: 'utf-8',
                timeout: ['30s', '30s'],
                dataType: 'json',
                contentType: 'json',
                gzip: true
            });
            ctx.logger.info('host', host + cityConfigUrl, JSON.stringify(ret.data.code));
            if (ret.data.code === 0) {
                cityLists = [];
                cityTypeLists = [];
                ret.data.data.map(Prov => {
                    let newProv = {provinceName: Prov.provinceName, citys: []};
                    Prov.citys.map(city => {
                        city.type = "51gs";
                        if (city.state === -1 && newCityMap.get(String(city.id)) && newCityMap.get(String(city.id)).state !== -1) {
                            city = newCityMap.get(String(city.id));
                            city.type = "gsgj";
                            ctx.logger.info('city',city)
                        }
                        cityMap.set(String(city.id), city);
                        if (city.state != 1) {
                            city.state = -1;
                        }
                        newProv.citys.push({
                            province: city.province,
                            name: city.name,
                            id: city.id,
                            state: city.state,
                            queryParam: city.queryParam
                        });
                        cityTypeLists.push({
                            province: city.province,
                            name: city.name,
                            id: city.id,
                            state: city.state,
                            type: city.type,
                        })
                    });
                    cityLists.push(newProv);
                });
                ctx.app.cityLists = cityLists;
                ctx.app.cityTypeLists = cityTypeLists;
            }
        } catch (e) {
            ctx.logger.error('【schedule/cityList】catch error:', JSON.stringify(e));
        }
    }
};
