'use strict';

module.exports = {
    schedule: {
        interval: '1m', // 5分钟间隔
        type: 'all', // 所有woker
        immediate: true,
    },
    async task(ctx) {
        try {
            const {host, newhost, cityConfigUrl} = ctx.app.config.taskAPI;
            let cityLists = [];//对外城市列表
            let cityTypeLists = [];//不对外城市列表，含渠道（51/管家）
            let newCityMap = new Map();
            let cityMap=new Map();

            const newret = await ctx.curl(newhost + cityConfigUrl, {
                charset: 'utf-8',
                timeout: ['30s', '30s'],
                dataType: 'json',
                contentType: 'json',
                gzip: true
            });
            ctx.logger.info('cityList--newhost', newhost, JSON.stringify(newret.data.code));
            if (newret.data.code === 0) {
                newret.data.data.map(Prov => {
                    Prov.citys.map(city => {
                        newCityMap.set(String(city.id), city)
                    })
                })
            }

            const ret = await ctx.curl(host + cityConfigUrl, {
                charset: 'utf-8',
                timeout: ['30s', '30s'],
                dataType: 'json',
                contentType: 'json',
                gzip: true
            });
            ctx.logger.info('cityList--host', host, JSON.stringify(ret.data.code));
            if (ret.data.code === 0) {
                cityLists = [];
                cityTypeLists = [];
                ctx.logger.info('start')
                ret.data.data.map(Prov => {
                    ctx.logger.info('newProv')
                    let newProv = {provinceName: Prov.provinceName, citys: []};
                    Prov.citys.map(city => {
                        ctx.logger.info('51gs')
                        city.type = "51gs";
                        if (city.state === -1 && newCityMap.get(String(city.id)) && newCityMap.get(String(city.id)).state !== -1) {
                            city = newCityMap.get(String(city.id));
                            city.type = "gsgj";
                            ctx.logger.info('city',city)
                        }
                        cityMap.set(String(city.id), city);
                        if (city.state != 1) {
                            city.state = -1;
                            ctx.logger.info('state')
                        }
                        newProv.citys.push({
                            province: city.province,
                            name: city.name,
                            id: city.id,
                            state: city.state,
                            queryParam: city.queryParam
                        });
                        ctx.logger.info('newProv-push')
                        cityTypeLists.push({
                            province: city.province,
                            name: city.name,
                            id: city.id,
                            state: city.state,
                            type: city.type,
                        });
                        ctx.logger.info('cityTypeLists-push')
                    });
                    ctx.logger.info('newProv-end')
                    cityLists.push(newProv);
                });
                ctx.logger.info('cityLists', cityLists.length, 'cityTypeLists', cityTypeLists[0])
                ctx.app.cityLists = cityLists;
                ctx.app.cityTypeLists = cityTypeLists;
            }else{
                ctx.logger.info('拉配置出错')
            }
        } catch (e) {
            ctx.logger.error('【schedule/cityList】catch error:', JSON.stringify(e));
        }
    }
};
