'use strict';

const Service = require('egg').Service;

class WashDataService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config } = this;
    this.washUrl = config.washAPI.host + config.washAPI.washUrl;
  }
  async wash(data) {
    const { app, washUrl } = this;
    const rawdata = this._switchData(data);
    if (!washUrl) return rawdata;
    const washData = await app.curl(washUrl,
      {
        charset: 'utf-8',
        timeout: ['30s', '30s'],
        dataType: 'json',
        data: rawdata,
        method: 'post',
        contentType: 'json',
      });
    if (washData.status !== 200) {
      throw new Error('清洗数据出错');
    }
    if (washData.data.code !== 0) {
      throw new Error('清洗数据出错');
    }

    return washData.data;
  }

  _switchData(data, appKey = '', orderId = '') {
    const tmp = data.data;
    const bar = {};
    bar.taskId = tmp.taskId;
    bar.cityId = tmp.cityId;
    bar.data = JSON.parse(tmp.data);
    bar.orderID = orderId;
    bar.appKey = appKey;
    return bar;
  }
}

module.exports = WashDataService;
