'use strict';

const Service = require('egg').Service;

class OrderService extends Service {
  async getOneByOrderId(orderId) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: { orderId },
      order: [['createDate', 'DESC']],
    });
    return order;
  }

  async getOneByTaskId(taskId) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: { taskId },
    });
    return order;
  }

  async create(params) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findOne({
      where: { orderId: params.orderId },
    });
    if (order) {
      ctx.throw(400, { message: 'already have order' });
    }
    await ctx.model.TaskStatus.create(params);
    return order;
  }

  async update(params) {
    const { ctx } = this;
    const order = await ctx.model.TaskStatus.findAll({
      where: { orderId: params.orderId },
      order: [['createDate', 'DESC']],
    });
    if (order.length === 0) {
      ctx.throw(400, { message: 'no order' });
      return;
    }
    for (const item of order) {
      if (item.status === 'success') {
        ctx.throw(400, { message: 'orderId success' });
        return;
      }
    }
    const { appkey, taskId, notifyUrl, redirectUrl, userId } = order[0];
    if (taskId) {
      await ctx.model.TaskStatus.create({ appkey, status: 'init', notifyUrl, backUrl: redirectUrl, userId, ...params })
    } else {
      await order[0].update(params);
    }
    return order[0];
  }
}

module.exports = OrderService;
