'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { partnerAPI } } = this;
    this.partnerAPI = partnerAPI;
  }

  async fetchTheme(appKey) {
    const { ctx, partnerAPI: { fetchTheme, host, redisThemePrefix } } = this;
    if (appKey) {
      const data = await this.app.redis.get(redisThemePrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Scripts】fetchParams', redisThemePrefix + appKey, 'result:', data, err);
          await this.app.redis.del(redisThemePrefix + appKey);
        }
      }
    }
    const ret = await ctx.curl(`${host + fetchTheme}`, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
      data: {
        appKey,
        subject: 'it'
      }
    });
    ctx.logger.info(`【Partner】 fetchTheme ${host + fetchTheme}/${appKey}`, ret.data);
    if (ret.status === 200 && ret.data && ret.data.length > 0 && ret.data[0].appKey === appKey) {
      await this.app.redis.set(redisThemePrefix + appKey, JSON.stringify(ret.data[0]), 'EX', 300);
    }
    return ret.data[0];
  }

  async fetchInfo(appKey){
    const { ctx, partnerAPI: { fetchInfo, host, redisInfoPrefix } } = this;
    if (appKey) {
      const data = await this.app.redis.get(redisInfoPrefix + appKey);
      ctx.logger.info('【Scripts】fetchInfo redis data', redisInfoPrefix + appKey, 'result:', data);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.info('【Scripts】fetchInfo redis err', redisInfoPrefix + appKey, 'result:', data, err);
          await this.app.redis.del(redisInfoPrefix + appKey);
        }
      }
    }

    const ret = await ctx.curl(`${host + fetchInfo}`, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
      data: {
        appKey
      }
    });
    ctx.logger.info(`【Partner】 fetchTheme ${host + fetchInfo}?appKey=${appKey}`, ret.data);
    if (ret.status === 200 && ret.data && ret.data.length > 0 && ret.data[0].appKey === appKey) {
      await this.app.redis.set(redisInfoPrefix + appKey, JSON.stringify(ret.data[0]), 'EX', 300);
    }
    return ret.data[0];
  }

  async fetchScripts(appKey) {
    const { ctx, partnerAPI: { fetchScripts, host, redisScriptsPrefix } } = this;

    if (appKey) {
      const data = await this.app.redis.get(redisScriptsPrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Partner】 fetchScripts', redisScriptsPrefix + appKey, 'result:', JSON.stringify(data), err);
          await this.app.redis.del(redisScriptsPrefix + appKey);
        }
      }
    }
    const url = `${host + fetchScripts}/${appKey}`;
    const ret = await ctx.curl(url, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
    });
    ctx.logger.info(`【Partner】 fetchTheme ${url}`, JSON.stringify(ret.data));
    if (ret.status === 200 && ret.data && ret.data.id === appKey) {
      await this.app.redis.set(redisScriptsPrefix + appKey, JSON.stringify(ret.data), 'EX', 300);
    }
    return ret.data;
  }

  async fetchAgreements(id) {
    const { ctx, partnerAPI: { fetchAgreements, host, redisAgreementsPrefix } } = this;
    const data = await this.app.redis.get(redisAgreementsPrefix + id);
    if (data) {
      try {
        return JSON.parse(data);
      } catch (err) {
        ctx.logger.error('【Partner】 fetchAgreements', redisAgreementsPrefix + id, 'result:', JSON.stringify(data), err);
        await this.app.redis.del(redisAgreementsPrefix + id);
      }
    }
    const url = `${host + fetchAgreements}/${id}`;
    const ret = await ctx.curl(url, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
    });
    ctx.logger.info(`【Partner】 fetchAgreements ${url}`, JSON.stringify(ret.data));
    if (ret.status === 200 && ret.data && ret.data.id === id) {
      await this.app.redis.set(redisScriptsPrefix + appKey, JSON.stringify(ret.data), 300);
    }
    return ret.data;
  }

  async notice(order) {
    const { ctx } = this;
    ctx.logger.info(`【Partner】 notice into`);
    const { orderId, notifyUrl, userId } = order;
    if (notifyUrl) {
        try{
            const ret = await ctx.curl(notifyUrl, {
                    charset: 'utf-8',
                    timeout: ['30s', '30s'],
                    contentType: 'json',
                    method: 'POST',
                    data: {
                        orderId,
                        userId,
                        status: 'success'
                    },
                }
            );
            ctx.logger.info(`【Partner】 notice ${notifyUrl}`, 'orderId:', orderId, 'result:', ret.status, JSON.stringify(ret.data));
            if (ret.status == 200) {
                await order.update({ notice: 1 });
            }else{
                await order.update({ notice: ret.status });
            }
        }catch (e) {
            ctx.logger.info(`【Partner】 notice err ${e}`)
        }finally {
            return
        }
    }
  }
}

module.exports = PartnerService;
