'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { router, controller } = app;

  const itRouter = router.namespace(app.config.projectRootPath);
  itRouter.post('/tasks', controller.task.create); // 创建任务
  itRouter.get('/tasks/:taskId', controller.task.show); // 获取任务状态
  itRouter.post('/tasks/:taskId/submit', controller.task.submit); // 提交任务参数
  itRouter.post('/tasks/:taskId/capture', controller.task.fetchCapture); // 获取验证码

  itRouter.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外


  itRouter.get('/scripts', controller.script.fetchScripts); // 获取所有脚本信息
  itRouter.get('/scripts/:scriptId', controller.script.fetchOneScripts); // 获取单一脚本信息
  itRouter.get('/help/:scriptId', controller.script.fetchHelpInfo); // 获取帮助信息
  itRouter.get('/notice/:scriptId', controller.script.fetchNoticeInfo);// 获取提示信息
  itRouter.get('/query_button/:scriptId', controller.script.fetchQueryButtonInfo); // 获取查询按钮信息
  itRouter.get('/params', controller.script.fetchParamsInfo); // 获取登录参数字典

  itRouter.get('/hubs/:hubId/scripts', controller.script.fetchHubSeripts);// 根据hubId 获取脚本数据（数组）支持auto


  itRouter.get('/theme/:appKey', controller.partner.show);// 配置主题
  itRouter.get('/agreements/:id', controller.partner.fetchAgreements);//查询协议


  itRouter.post('/tokens', controller.token.create); // 创建token
  itRouter.post('/orders', controller.order.create); // 创建订单号


  itRouter.post('/getToken', controller.token.partnerToken);     // 合作方获取token
  itRouter.post('/getOrderSn', controller.order.partnerOrder);   // 合作方获取orderSn

  itRouter.post('/getCity', controller.task.cityConfigs);        // 获取城市配置
  itRouter.post('/getData', controller.order.partnerData);       // 合作方拉数据

  itRouter.get('/orderData/:appKey/:orderId', controller.order.orderShow);//获取展示页面数据
};
