'use strict';

const Service = require('egg').Service;

class TaskService extends Service {
    constructor(ctx) {
        super(ctx);
        const {config} = this;
        const {taskAPI, LOCK_KEY} = config;
        this.baseURL = taskAPI.host;
        this.newbaseURL = taskAPI.newhost;
        this.createTaskUrl = taskAPI.createTaskUrl;
        this.submitTaskUrl = taskAPI.submitTaskUrl;
        this.fetchCodeUrl = taskAPI.fetchCodeUrl;
        this.fetchTaskUrl = taskAPI.fetchTaskUrl;
        this.cityConfigUrl = taskAPI.cityConfigUrl;
        this.LOCK_KEY = LOCK_KEY;
    }


    _request(url, type, opts) {
        const {ctx, baseURL, newbaseURL} = this;
        url = (type === 'gsgj') ? `${newbaseURL}${url}` : `${baseURL}${url}`;
        opts = {
            charset: 'utf-8',
            timeout: ['30s', '30s'],
            dataType: 'json',
            contentType: 'json',
            ...opts,
        };
        ctx.logger.info('_request', url, type);
        return ctx.curl(url, opts);
    }

    _checkSuccess(result) {
        if (result.status !== 200) {
            const errorMsg = result.data && result.data.error_msg ? result.data.error_msg : 'unknown error';
            this.ctx.throw(result.status, errorMsg);
        }
        if (result.data.code !== 0) {
            this.ctx.throw(400, {message: result.data.msg, code: result.data.code});
        }
    }

    async create({scriptId, channelType}) {
        const {createTaskUrl, ctx} = this;
        const result = await this._request(createTaskUrl, channelType, {
            method: 'post',
            data: {cityId: scriptId},
        });
        ctx.logger.info(`【Task】create ${createTaskUrl} cityId: ${scriptId} channelType: ${channelType} result:`, JSON.stringify(result.data));
        this._checkSuccess(result);
        return result.data.data.taskId;
    }

    async fetchCapture({taskId, type}) {
        const {fetchCodeUrl, ctx} = this;
        let channelType = taskId.length > 20 ? 'gsgj' : '51gs';
        const result = await this._request(fetchCodeUrl, channelType, {
            method: 'post',
            data: {
                taskId,
                type,
            },
        });
        ctx.logger.info(`【Task】fetchCapture ${fetchCodeUrl} params`, JSON.stringify({
            taskId,
            type,
        }), result.data.code);
        this._checkSuccess(result);
        return result.data.data;
    }

    async submit(data) {
        const {submitTaskUrl, ctx} = this;
        let channelType = data.taskId.length > 20 ? 'gsgj' : '51gs';
        const result = await this._request(submitTaskUrl, channelType, {
            method: 'post',
            data,
        });
        ctx.logger.info(`【Task】submit ${submitTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data));
        this._checkSuccess(result);
        return result;
    }

    async fetchTask(data) {
        const {fetchTaskUrl, ctx} = this;
        let channelType = data.taskId.length > 20 ? 'gsgj' : '51gs';
        const result = await this._request(fetchTaskUrl, channelType, {
            method: 'post',
            data,
        });
        ctx.logger.info(`【Task】fetchTask ${fetchTaskUrl} params`, JSON.stringify(data), JSON.stringify(result.data.code));
        return result.data;
    }

    async getCityList() {
        const {cityConfigUrl, ctx} = this;
        let cityLists = [];//对外城市列表
        let cityTypeLists = [];//不对外城市列表，含渠道（51/管家）
        let newCityMap = new Map();

        const newret = await this._request(cityConfigUrl, 'gsgj', {method: 'get'});
        ctx.logger.info(`【Task】getCityList params gsgj`, newret.status, newret.data.data.length);
        this._checkSuccess(newret);
        newret.data.data.map(Prov => {
            Prov.citys.map(city => {
                newCityMap.set(String(city.id), city)
            })
        });

        const ret = await this._request(cityConfigUrl, '51gs', {method: 'get'});
        ctx.logger.info(`【Task】getCityList params 51gs`, ret.status, ret.data.data.length);
        this._checkSuccess(ret);
        ret.data.data.map(Prov => {
            let newProv = {provinceName: Prov.provinceName, citys: []};
            Prov.citys.map(city => {
                city.type = "51gs";
                if (city.state === -1 && newCityMap.get(String(city.id)) && newCityMap.get(String(city.id)).state === 1) {
                    city = newCityMap.get(String(city.id));
                    city.type = "gsgj";
                    ctx.logger.info('city', city)
                }
                if (city.state != 1) {
                    city.state = -1;
                }
                newProv.citys.push({
                    province: city.province,
                    name: city.name,
                    id: city.id,
                    state: city.state,
                    queryParam: city.queryParam
                });
                ctx.app.redis.set(city.id, city.type, "EX", 3600)
            });
            cityLists.push(newProv);
        });
        return cityLists;
    }
}

module.exports = TaskService;
