'use strict';

const Controller = require('egg').Controller;

class OrderController extends Controller {
    constructor(ctx) {
        super(ctx);
        this.createRule = {
            appKey: 'string',
            userId: {
                type: 'string',
                required: false,
            },
            orderId: {
                type: 'string',
                required: false,
                format: /^(\w{8})-(\w{4})-(\w{4})-(\w{4})-(\w{12})$/,
                message: '订单号格式错误',
            }
        };

        this.partnerOrderRule = {
            sign: 'string',
            params: {
                type: 'object',
                rule: {
                    token: 'string',
                    appKey: 'string',
                    timestamp: 'string',
                },
            },
        };

        this.showRule = {
            sign: 'string',
            params: {
                type: 'object',
                rule: {
                    token: 'string',
                    orderSn: 'string',
                    appKey: 'string',
                    timestamp: 'string',
                },
            },
        };
    }

    async create() {
        const { ctx, service } = this;
        ctx.validate(this.createRule);
        let { appKey, userId, notifyUrl, backUrl, orderId } = ctx.request.body;
        const appKeyInfo = await service.partner.fetchInfo(appKey);
        ctx.logger.info(appKey, ',appKeyInfo,', appKeyInfo);
        if (!(appKeyInfo && appKeyInfo.valid === true && appKeyInfo.enableIt === true)) {
            return ctx.fail('未开通此服务');
        }
        const object = {
            orderId,
            taskId: '',
            userId: userId || '',
            cityId: '',
            notifyUrl: notifyUrl || (ctx.app.notifyMap && ctx.app.notifyMap.get(appKey) && ctx.app.notifyMap.get(appKey).notifyUrl) || '',
            backUrl: backUrl || '',
            appkey: appKey,
            status: 'init',
        };
        if (orderId) {
            await service.order.update(object);
        } else {
            object.orderId = ctx.helper.getUuid();
            await service.order.create(object);
        }
        ctx.success({ orderId: object.orderId });
    }

    async partnerOrder() {
        const {ctx, service} = this;
        ctx.validate(this.partnerOrderRule);
        const {appKey} = ctx.request.body.params;
        const result = await service.signature.partnerOrderId(ctx.request.body);
        await service.order.create({
            orderId: result.data.orderSn,
            taskId: '',
            userId: '',
            cityId: '',
            appkey: appKey,
            status: 'init',
        });
        ctx.success(result);
    }

    async partnerData() {
        const {ctx, service} = this;
        ctx.validate(this.showRule);
        const {appKey, orderSn} = ctx.request.body.params;
        await service.signature.signatureCheck(ctx.request.body);
        const data = await service.order.getOneByOrderId(orderSn);
        if (data && data.status === 'success') {
                const result = await service.storage.read(orderSn, appKey);
                ctx.body = {
                    code: 0,
                    data: result
                };
                return;
        }
        ctx.body = {
            code: -1,
            message: '无此订单号'
        };
    }

    async orderShow() {
        const { ctx, service } = this;
        const { appKey, orderId } = ctx.params;
        const appKeyInfo = await service.partner.fetchInfo(appKey);
        if (!(appKeyInfo && appKeyInfo.valid === true && appKeyInfo.enableItView === true)) {
            return ctx.fail('未开通此服务');
        }
        const data = await service.order.getOneByOrderId(orderId);
        if (data) {
            if (data.status === 'success' && (data.appkey === appKey)) {
                const result = await service.storage.read(orderId, appKey);
                // const ret = service.washData.dealData(result);
                ctx.success(result);
                return;
            }
        }
        ctx.fail('无此订单号');
    }
}

module.exports = OrderController;
