'use strict';

module.exports = () => {
  const config = exports = {};
  config.debug = true;
  config.logger = {
    dir: '/jianbing/logs/it_h5_server',
  };

  config.projectRootPath = '/IncomeTax';

  config.redis = {
    client: {
      port: 6379,
      host: process.env.REDIS_HOST,
      password: process.env.REDIS_PWD,
      db: 0,
    },
  };
  config.taskAPI = {
    host: 'http://ts1.51gjj.com:6824',
    fetchHubsUrl: '',
    createTaskUrl: '/IncomeTax/createItTask',
    fetchCodeUrl: '/IncomeTax/getItCode',
    submitTaskUrl: '/IncomeTax/loginItWeb',
    fetchTaskUrl: '/IncomeTax/getItData',
  };

  config.partnerAPI = {
    host: process.env.ZEUS_API_HOST,
    fetchTheme: '/chaos/partners/theme',
    fetchScripts: '/chaos/partners/scripts',
    redisThemePrefix: 'URANUS.HF.PARNTERS.THEME',
    redisScriptsPrefix: 'URANUS.HF.PARNTERS.SCRIPTS',
  };

  config.scriptsAPI = {
    host: process.env.ZEUS_API_HOST,
    fetchScriptsUrl: '/chaos/it/two_dimension_array/queries',
    fetchOneScriptUrl: '/chaos/it/two_dimension_array/info',
    fetchParamsInfoUrl: '/chaos/it/login_param_map',
    fetchQueryButtonUrl: '/chaos/it/query_button',
    fetchHelpUrl: '/chaos/it/help',
    fetchNoticeUrl: '/chaos/it/notice',
    fetchHubSeriptsUrl: '/chaos/it/hubs',
    fetchScriptByCityNameUrl: '/chaos/it/city_scripts',
    redisScriptsKey: 'URANUS.IT.SCRIPTS',
    redisParamsKey: 'URANUS.IT.PARAMS',
  };

  config.storageAPI = {
    host: process.env.STORAGE_API_HOST,
    writeUrl: '/data',
    readUrl: '/IncomeTax',
    writeType: 'incomeTax',
    readDataKey: 'incometaxData',
  };

  config.washAPI = {
    host: '',
    washUrl: '',
  };

  config.signatureAPI = {
    host: process.env.SIGNATURE_API_HOST,
    fetchTokenUrl: '/Access/GetToken',
    fetchOrderIdUrl: '/Order/GetOrderSn',
    signatureUrl: '/Access/SignValidityCheck',
    fetchParnterUrl: '',
    signatureType: 'incomeTax',
  };

  config.lockKeys = {
    fecthHub: 'URANUS.IT.HUBS.LOCK',
    fecteToken: 'URANUS.IT.TOKEN.LOCK',
    token: 'URANUS.IT.TOKEN',
    fecthParnters: 'URANUS.PARNTERS.LOCK',
    taskPrefix: 'URANUS.TASK',
  };

  config.lockKeys = {
    fecthHub: 'URANUS.HF.HUBS.LOCK',
    fecteToken: 'URANUS.HF.TOKEN.LOCK',
    token: 'URANUS.HF.TOKEN',
    fecthParnters: 'URANUS.PARNTERS.LOCK',
    taskPrefix: 'URANUS.TASK',
  };
  config.projectRootPath = '';

  config.sequelize = {
    datasources: [{
      // 东八时区
      timezone: '+08:00',
      delegate: 'model',
      baseDir: 'model',
      dialect: 'mysql',
      host: process.env.MYSQL_HOST,
      database: 'data_service_uat',
      username: process.env.MYSQL_USER,
      password: process.env.MYSQL_PWD,
      port: 3306,
    }],
  };

  config.GJJ_OpenAPI = {
    appKey: '9FBBA75BBFC24401AA6A76AEFC277346',
    appSecret: 'D7FEA664E0CD4336BEAA1B3569393A301DBB6995',
  };

  config.callbackUrl = process.env.CALLBACK_URL;

  return config;
};
