import logging
import os
import sys
import traceback

import pandas as pd
from config import configs


def logger_config(filename):
    logger = logging.getLogger('')
    logger.setLevel(logging.INFO)
    handler = logging.FileHandler(filename, 'w', encoding='utf8')
    handler.setFormatter(logging.Formatter('%(asctime)s - %(message)s'))
    logger.addHandler(handler)
    return logger

def test(x):
    return x


if __name__ == '__main__':
    data = [
        {'city': '杭州', 'ID': '33018219940121216', 't_ID': '1', 'name': 'anan', 't_name': '1'},
        {'city': '上海', 'ID': '33018219940165466', 't_ID': '1', 'name': 'lolo', 't_name': '1'},
        {'city': '上海', 'ID': '2326****0322', 't_ID': '1', 'name': 'qwe', 't_name': '2'},
        {'city': '上海', 'ID': '2326****0322', 't_ID': '1', 'name': 'qwe', 't_name': '2'},
        {'city': '上海', 'ID': '2326****12365', 't_ID': '1',},
        {'city': '上海', 'ID': '34234****23123', 't_ID': '1', 'name': 'aaa', 't_name': '4'},
        {'city': '北京', 'ID': '3435****2763', 't_ID': '1', 'name': 'ccc', 't_name': '4'},
        {'city': '北京', 'ID': '2326****67675', 't_ID': '1', 'name': 'ddd', 't_name': '3'},
        {'city': '雅安', 'name': 'zzz', 't_name': '4'},
    ]
    df = pd.DataFrame(data)
    df.fillna('')
    print(df.ix[0]['ID'])
    grouped = df.groupby([df['city'], df['t_name']])
    for (cc, k), g in grouped:
        print(cc, k)
        d = g[:2]

        print(d.T.to_dict().values())
    print(configs)    
