#  -*- coding: utf-8 -*-


import datetime
from dateutil.relativedelta import relativedelta


def away_today(date):
    """ caluate how long from today """
    if date and isinstance(date, str):
        today = datetime.date.today()
        date = date.split('-')
        date = datetime.date(year=int(date[0]), month=int(date[1]), day=int(date[2]))
        datedelta = relativedelta(today, date)
        return datedelta.years, datedelta.months, datedelta.days


def format_date(raw):
    year = int(raw[:4])
    mon = int(raw[4:])
    return datetime.date(year=year, month=mon, day=1)





