#  -*-  coding: utf8  -*-

import configs_default

def merge(defaults, override):
    r = {}
    for k, v in defaults.items():
        if k in override:
            if isinstance(v, dict):
                r[k] = merge(v, override[k])
            else:
                r[k] = override[k]
        else:
            r[k] = v
    return r


def toDict(d):
    result = dict()
    for k, v in d.items():
        result[k] = toDict(v) if isinstance(v, dict) else v
    return result

configs = configs_default.configs

try:
    import configs_override
    configs = merge(configs, configs_override.configs)
except ImportError:
    pass

configs = toDict(configs)
