'use strict';

/**
 * @param {Egg.Application} app - egg application
 */
module.exports = app => {
  const { router, controller } = app;

  const chsiRouter = router.namespace(app.config.projectRootPath);

  chsiRouter.get('/getorderSn/:appKey', controller.order.fetchOrderId);// 合作方获取订单号

  // taxRouter.post('/getCode', controller.task.fetchCapture);// 获取验证码

  chsiRouter.post('/query', controller.task.submit);// 提交任务查询参数

  chsiRouter.post('/getToken', controller.token.partnerCreate);// 合作方创建token

  chsiRouter.post('/getData', controller.order.partnerShow);// 合作方获取订单数据

  chsiRouter.post('/callback', controller.task.handleCallback); // 处理回调结果，不对外
};
