'use strict';

const Service = require('egg').Service;

class PartnerService extends Service {
  constructor(ctx) {
    super(ctx);
    const { config: { partnerAPI } } = this;
    this.partnerAPI = partnerAPI;
  }

  async fetchInfo(appKey){
    const { ctx, partnerAPI: { fetchInfo, host, redisInfoPrefix } } = this;
    if (appKey) {
      const data = await this.app.redis.get(redisInfoPrefix + appKey);
      if (data) {
        try {
          return JSON.parse(data);
        } catch (err) {
          ctx.logger.error('【Scripts】fetchInfo', redisInfoPrefix + appKey, 'result:', data, err);
          await this.app.redis.del(redisInfoPrefix + appKey);
        }
      }
    }

    const ret = await ctx.curl(`${host + fetchInfo}`, {
      charset: 'utf-8',
      timeout: ['30s', '30s'],
      dataType: 'json',
      method: 'GET',
      data: {
        appKey
      }
    });
    ctx.logger.info(`【Partner】 fetchTheme ${host + fetchInfo}?appKey=${appKey}`, ret.data);
    if (ret.status === 200 && ret.data && ret.data.length > 0 && ret.data[0].appKey === appKey) {
      await this.app.redis.set(redisInfoPrefix + appKey, JSON.stringify(ret.data[0]), 'EX', 300);
    }
    return ret.data[0];
  }

  async notice(order) {
    const { ctx } = this;
    const { orderId, notifyUrl, notice } = order;
    if (notifyUrl && notice !== '1') {
      const ret = await ctx.curl(notifyUrl, {
        charset: 'utf-8',
        timeout: ['30s', '30s'],
        contentType: 'json',
        method: 'POST',
        data: {
          orderSn: orderId
        },
      }
      )
      ctx.logger.info(`【Partner】 notice ${notifyUrl}`, 'orderId:', orderId, 'result:', ret.status, JSON.stringify(ret.data));
      if (ret.status == 200) {
        await order.update({ notice: '1' });
      }
    }
    return;
  }
}

module.exports = PartnerService;
